/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.tree.AbstractSchemaType;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.OrderByItem;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Select;
import com.sap.ejbql.tree.SelectAggregate;
import com.sap.ejbql.tree.SelectPath;
import com.sap.ejbql.tree.TreeBuildException;
import com.sap.ejbql.tree.TreeNode;
import com.sap.ejbql.tree.Type;
import java.util.ArrayList;

public class Query
extends TreeNode {
    Select select = null;
    ArrayList from = null;
    ConditionalExpression where = null;
    ArrayList orderBy;
    private IdVarDeclaration[] cachedFrom;
    private OrderByItem[] cachedOrderBy;

    public Query() {
        super(null, null);
    }

    public Query(IdVarDeclaration[] from) {
        this();
        if (from == null) {
            return;
        }
        int i = 0;
        while (i < from.length) {
            this.addDeclaration(from[i]);
            ++i;
        }
    }

    public void setSelect(Select s) {
        if (this.from == null) {
            throw new TreeBuildException("You have to specify the from part first");
        }
        this.select = s;
        if (this.select != null) {
            this.select.check(this.getDeclarations());
        }
    }

    public Select getSelect() {
        return this.select;
    }

    public void addDeclaration(IdVarDeclaration decl) {
        if (decl == null) {
            return;
        }
        if (this.from == null) {
            this.from = new ArrayList();
        }
        this.errColl = decl.errColl;
        int i = 0;
        while (i < this.from.size()) {
            IdVarDeclaration d = (IdVarDeclaration)this.from.get(i);
            if (d.normalizedName.equals(decl.normalizedName)) {
                this.error(decl.pos, "Variable '" + d.name + "' already declared" + (!d.name.equals(decl.name) ? " (variables are case-insensitive)" : ""));
                return;
            }
            ++i;
        }
        this.cachedFrom = null;
        this.from.add(decl);
    }

    public IdVarDeclaration[] getDeclarations() {
        if (this.from == null) {
            return null;
        }
        if (this.cachedFrom != null) {
            return this.cachedFrom;
        }
        this.cachedFrom = new IdVarDeclaration[this.from.size()];
        this.from.toArray(this.cachedFrom);
        return this.cachedFrom;
    }

    public void setWhere(ConditionalExpression e) {
        this.where = e;
    }

    public ConditionalExpression getWhere() {
        return this.where;
    }

    public void addOrderByItem(OrderByItem item) {
        if (this.select == null) {
            throw new TreeBuildException("You have to specify the select part first");
        }
        if (item == null) {
            return;
        }
        if (this.orderBy == null) {
            this.orderBy = new ArrayList();
        }
        if (this.select instanceof SelectAggregate) {
            this.error(item.pos, "ORDER BY clause not allowed with aggregate selection");
            return;
        }
        this.cachedOrderBy = null;
        this.orderBy.add(item);
        Type returnType = this.select.returnType;
        if (returnType == Type.UNKNOWN) {
            return;
        }
        if (returnType.isEntityBean()) {
            item.check((AbstractSchemaType)returnType);
        } else {
            SelectPath sel = (SelectPath)this.select;
            PathExpression path = sel.path;
            Type returnAsType = path.getAbstractSchemaType();
            if (returnAsType != Type.UNKNOWN && path.field != null) {
                item.check((AbstractSchemaType)returnAsType, path.field.name);
            }
        }
    }

    public OrderByItem[] getOrderByItems() {
        if (this.orderBy == null) {
            return null;
        }
        if (this.cachedOrderBy != null) {
            return this.cachedOrderBy;
        }
        this.cachedOrderBy = new OrderByItem[this.orderBy.size()];
        this.orderBy.toArray(this.cachedOrderBy);
        return this.cachedOrderBy;
    }

    public String toString() {
        int i;
        int len;
        StringBuffer str = new StringBuffer(512);
        str.append("SELECT " + this.select + " ");
        if (this.from != null) {
            len = this.from.size();
            if (len > 0) {
                str.append("FROM " + this.from.get(0).toString());
            }
            i = 1;
            while (i < len) {
                str.append(", " + this.from.get(i).toString());
                ++i;
            }
        }
        if (this.where != null) {
            str.append(" WHERE " + this.where.toString());
        }
        if (this.orderBy != null) {
            len = this.orderBy.size();
            if (len > 0) {
                str.append(" ORDER BY " + this.orderBy.get(0).toString());
            }
            i = 1;
            while (i < len) {
                str.append(", " + this.orderBy.get(i).toString());
                ++i;
            }
        }
        return str.toString();
    }
}

