/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.EjbQlException;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.AbstractSchemaType;
import com.sap.ejbql.tree.CmpField;
import com.sap.ejbql.tree.CmrField;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.IdentificationVariable;
import com.sap.ejbql.tree.TreeNode;
import com.sap.ejbql.tree.Type;
import java.util.ArrayList;

public class PathExpression
extends Expression {
    IdentificationVariable idVar;
    ArrayList path = new ArrayList();
    CmpField field;
    ArrayList unspecified;
    private CmrField[] cachedPath;

    public PathExpression(IdentificationVariable idvar) {
        super(null, idvar);
        this.idVar = idvar;
        if (idvar == null) {
            throw new IllegalArgumentException("'idvar' not defined");
        }
        this.type = idvar.type;
    }

    public PathExpression(IdVarDeclaration decl) {
        this(new IdentificationVariable(decl));
    }

    public PathExpression(IdVarDeclaration decl, String[] components) {
        this(new IdentificationVariable(decl));
        if (components == null) {
            return;
        }
        int i = 0;
        while (i < components.length) {
            this.addComponent(components[i]);
            ++i;
        }
    }

    public void addComponent(String component) {
        this.addComponent(component, null);
    }

    public void addComponent(String component, Position pos) {
        if (component == null) {
            throw new IllegalArgumentException("'component' not defined");
        }
        if (this.unspecified != null || this.type == Type.UNKNOWN) {
            this.addUnspecified(new UnspecifiedField(component, pos));
            return;
        }
        if (this.field != null) {
            this.error(pos, "Path '" + this + "' already ends in CMP field");
            return;
        }
        if (this.isCollectionValued()) {
            String oldPath = this.toString();
            this.addUnspecified(new UnspecifiedField(component, pos));
            this.error(pos, "Cannot extend collection-valued path '" + oldPath + "'");
            return;
        }
        AbstractSchemaType asType = (AbstractSchemaType)this.type;
        if (asType.hasCmrField(component)) {
            CmrField cmr;
            AbstractSchemaType fieldType = asType.getCmrFieldBaseType(component);
            if (asType.isSingleValued(component)) {
                cmr = new CmrField(component, fieldType, '1', pos);
            } else if (asType.isCollectionValued(component)) {
                cmr = new CmrField(component, fieldType, 'N', pos);
            } else {
                this.addUnspecified(new UnspecifiedField(component, pos));
                throw new EjbQlException("Inconsistency: uncomplete schema specification");
            }
            this.addComponent(cmr);
        } else if (asType.hasCmpField(component)) {
            Type fieldType = asType.getCmpFieldType(component);
            this.addComponent(new CmpField(component, fieldType, pos));
        } else {
            String oldPath = this.toString();
            this.addUnspecified(new UnspecifiedField(component, pos));
            this.error(pos, "Path '" + oldPath + "' (" + asType + ") has no component '" + component + "'");
        }
    }

    private void addComponent(CmrField cmr) {
        if (cmr == null) {
            return;
        }
        if (this.unspecified != null) {
            throw new EjbQlException("Cannot extend unspecified path");
        }
        if (this.field != null) {
            this.error(cmr.pos, "Path '" + this + "' already ends in CMP field");
            return;
        }
        this.cachedPath = null;
        this.path.add(cmr);
        this.type = cmr.type;
    }

    private void addComponent(CmpField cmp) {
        if (cmp == null) {
            return;
        }
        if (this.unspecified != null) {
            throw new EjbQlException("Cannot extend unspecified path");
        }
        if (this.field != null) {
            this.error(cmp.pos, "Path '" + this + "' already ends in CMP field");
            return;
        }
        this.field = cmp;
        this.type = cmp.type;
    }

    private void addUnspecified(UnspecifiedField field) {
        if (field == null) {
            return;
        }
        if (this.unspecified == null) {
            this.unspecified = new ArrayList();
        }
        this.unspecified.add(field);
        this.type = Type.UNKNOWN;
    }

    public IdentificationVariable getIdentificationVariable() {
        return this.idVar;
    }

    public CmpField getCmpField() {
        return this.field;
    }

    public CmrField[] getCmrFields() {
        if (this.cachedPath != null) {
            return this.cachedPath;
        }
        this.cachedPath = new CmrField[this.path.size()];
        this.path.toArray(this.cachedPath);
        return this.cachedPath;
    }

    public boolean isPath() {
        return true;
    }

    public boolean isSingleValued() {
        if (this.unspecified != null) {
            return true;
        }
        if (this.field != null) {
            return true;
        }
        if (this.path.size() == 0) {
            return true;
        }
        CmrField cmr = (CmrField)this.path.get(this.path.size() - 1);
        return cmr.isSingleValued();
    }

    public boolean isCollectionValued() {
        return this.unspecified != null || !this.isSingleValued();
    }

    public boolean isCmrPath() {
        return this.unspecified != null || this.field == null;
    }

    public boolean isCmpPath() {
        return this.unspecified != null || this.field != null;
    }

    public Type getAbstractSchemaType() {
        if (this.type == Type.UNKNOWN) {
            return this.type;
        }
        if (this.path.size() == 0) {
            return this.idVar.type;
        }
        CmrField cmr = (CmrField)this.path.get(this.path.size() - 1);
        return cmr.type;
    }

    public void check(IdVarDeclaration[] declarations) {
        this.idVar.check(declarations);
        if (this.unspecified == null || this.field != null || this.idVar.declaration == null) {
            return;
        }
        int len = this.path.size();
        this.type = len == 0 ? this.idVar.declaration.type : ((CmrField)this.path.get((int)(len - 1))).type;
        ArrayList unspec = this.unspecified;
        this.unspecified = null;
        int i = 0;
        while (i < unspec.size()) {
            UnspecifiedField u = (UnspecifiedField)unspec.get(i);
            this.addComponent(u.name, u.pos);
            ++i;
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer(256);
        str.append(this.idVar.toString());
        int i = 0;
        while (i < this.path.size()) {
            str.append("." + this.path.get(i).toString());
            ++i;
        }
        if (this.unspecified != null) {
            int i2 = 0;
            while (i2 < this.unspecified.size()) {
                str.append("." + this.unspecified.get(i2).toString());
                ++i2;
            }
        }
        if (this.field != null) {
            str.append("." + this.field.toString());
        }
        return str.toString();
    }

    private static class UnspecifiedField
    extends TreeNode {
        String name;

        UnspecifiedField(String name, Position pos) {
            super(pos, null);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

