/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.tree.AbstractSchemaType;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.TreeNode;
import com.sap.ejbql.tree.Type;

public class OrderByItem
extends TreeNode {
    PathExpression path;
    Direction dir;

    public OrderByItem(PathExpression path) {
        this(path, Direction.ASC);
    }

    public OrderByItem(PathExpression path, Direction dir) {
        super(path);
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        this.path = path;
        this.dir = dir;
        if (!path.isCmpPath()) {
            this.error(path.pos, "Path '" + path + "' is not a CMP path");
        }
    }

    public PathExpression getPath() {
        return this.path;
    }

    public boolean isAscending() {
        return this.dir == Direction.ASC;
    }

    public boolean isDescending() {
        return this.dir == Direction.DESC;
    }

    public void check(AbstractSchemaType returnType) {
        Type orderAsType = this.path.getAbstractSchemaType();
        if (orderAsType == Type.UNKNOWN) {
            return;
        }
        if (orderAsType != returnType) {
            this.error("Path '" + this.path + "' is not of same abstract schema type (" + orderAsType + ") as selected path (" + returnType + ")");
        } else if (this.path.isCmpPath() && !this.path.type.isOrdered()) {
            this.error("No order defined on type (" + this.path.type + ") of path '" + this.path + "'");
        }
    }

    public void check(AbstractSchemaType returnAsType, String cmpFieldName) {
        this.check(returnAsType);
        if (this.path.field != null && !cmpFieldName.equals(this.path.field.name)) {
            this.error("Ordering field '" + this.path.field + "' differs from field that is selected ('" + cmpFieldName + "')");
        }
    }

    public String toString() {
        return "" + this.path + (this.dir != null ? " " + this.dir : "");
    }

    public static class Direction {
        public static final Direction ASC = new Direction("ASC");
        public static final Direction DESC = new Direction("DESC");
        private String printableRepresentation;

        private Direction(String val) {
            this.printableRepresentation = val;
        }

        public String toString() {
            return this.printableRepresentation;
        }
    }
}

