/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.tree.Type;

public class NumericType
extends Type {
    public static final NumericType _byte_ = new NumericType("byte", true);
    public static final NumericType _short_ = new NumericType("short", true);
    public static final NumericType _char_ = new NumericType("char", true);
    public static final NumericType _int_ = new NumericType("int", true);
    public static final NumericType _long_ = new NumericType("long", true);
    public static final NumericType _float_ = new NumericType("float", true);
    public static final NumericType _double_ = new NumericType("double", true);
    public static final NumericType Byte = new NumericType("java.lang.Byte");
    public static final NumericType Short = new NumericType("java.lang.Short");
    public static final NumericType Character = new NumericType("java.lang.Character");
    public static final NumericType Integer = new NumericType("java.lang.Integer");
    public static final NumericType Long = new NumericType("java.lang.Long");
    public static final NumericType Float = new NumericType("java.lang.Float");
    public static final NumericType Double = new NumericType("java.lang.Double");
    public static final NumericType BigDecimal = new NumericType("java.math.BigDecimal");

    private NumericType(String name, boolean isPrimitive) {
        super(name, isPrimitive);
    }

    private NumericType(String name) {
        super(name, false);
    }

    static Type[] getBuiltinTypes() {
        return new NumericType[]{_byte_, _short_, _char_, _int_, _long_, _float_, _double_, Byte, Short, Character, Integer, Long, Float, Double, BigDecimal};
    }

    public boolean isNumeric() {
        return true;
    }

    public boolean isOrdered() {
        return true;
    }

    public boolean isDependentObject() {
        return false;
    }

    public boolean isByte() {
        return this == _byte_ || this == Byte;
    }

    public boolean isShort() {
        return this == _short_ || this == Short;
    }

    public boolean isCharacter() {
        return this == _char_ || this == Character;
    }

    public boolean isInteger() {
        return this == _int_ || this == Integer;
    }

    public boolean isLong() {
        return this == _long_ || this == Long;
    }

    public boolean isFloat() {
        return this == _float_ || this == Float;
    }

    public boolean isDouble() {
        return this == _double_ || this == Double;
    }

    public boolean isDecimal() {
        return this == Type.DECIMAL;
    }

    public boolean isConvertibleTo(Type tt) {
        if (this == tt) {
            return true;
        }
        if (!tt.isNumeric()) {
            return false;
        }
        NumericType t = (NumericType)tt;
        if (t.primitive && !this.primitive) {
            return false;
        }
        if (this.isByte()) {
            return t.isByte() || t.isShort() || t.isInteger() || t.isLong() || t.isDecimal() || t.isFloat() || t.isDouble();
        }
        if (this.isShort()) {
            return t.isShort() || t.isInteger() || t.isLong() || t.isDecimal() || t.isFloat() || t.isDouble();
        }
        if (this.isCharacter()) {
            return t.isCharacter() || t.isInteger() || t.isLong() || t.isDecimal() || t.isFloat() || t.isDouble();
        }
        if (this.isInteger()) {
            return t.isInteger() || t.isLong() || t.isDecimal() || t.isFloat() || t.isDouble();
        }
        if (this.isLong()) {
            return t.isLong() || t.isDecimal() || t.isFloat() || t.isDouble();
        }
        if (this.isDecimal()) {
            return t.isDecimal() || t.isFloat() || t.isDouble();
        }
        if (this.isFloat()) {
            return t.isFloat() || t.isDouble();
        }
        if (this.isDouble()) {
            return t.isDouble();
        }
        return false;
    }

    public static NumericType unaryPromotion(NumericType t) {
        if (t == _char_ || t == _short_ || t == _byte_) {
            return _int_;
        }
        if (t == Character || t == Short || t == Byte) {
            return Integer;
        }
        return t;
    }

    public static NumericType binaryPromotion(NumericType t1, NumericType t2) {
        if (t1 == _double_ || t2 == _double_) {
            return t1.primitive && t2.primitive ? _double_ : Double;
        }
        if (t1 == Double || t2 == Double) {
            return Double;
        }
        if (t1 == _float_ || t2 == _float_) {
            return t1.primitive && t2.primitive ? _float_ : Float;
        }
        if (t1 == Float || t2 == Float) {
            return Float;
        }
        if (t1 == BigDecimal || t2 == BigDecimal) {
            return BigDecimal;
        }
        if (t1 == _long_ || t2 == _long_) {
            return t1.primitive && t2.primitive ? _long_ : Long;
        }
        if (t1 == Long || t2 == Long) {
            return Long;
        }
        return t1.primitive && t2.primitive ? _int_ : Integer;
    }
}

