/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.Position;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.InputParameter;
import com.sap.ejbql.tree.PathExpression;

public class NullComparisonExpression
extends ConditionalExpression {
    Expression value;
    boolean negated;

    public NullComparisonExpression(PathExpression path) {
        this(path, null);
    }

    public NullComparisonExpression(InputParameter param) {
        this(param, null);
    }

    public NullComparisonExpression(PathExpression path, Position pos) {
        super(pos, path == null ? null : path.errColl);
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        if (!path.isSingleValued()) {
            this.error(path.pos, "Path '" + path + "' is not single-valued");
        }
        this.value = path;
    }

    public NullComparisonExpression(InputParameter param, Position pos) {
        super(pos, param == null ? null : param.errColl);
        if (param == null) {
            throw new IllegalArgumentException("'param' not defined");
        }
        this.value = param;
    }

    public void negate() {
        this.negated = !this.negated;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    public Expression getValue() {
        return this.value;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        return "" + this.value + (this.negated ? " IS NOT NULL" : " IS NULL");
    }
}

