/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.NumericType;
import com.sap.ejbql.tree.Type;
import java.math.BigDecimal;

public class Literal
extends Expression {
    String value;

    public Literal(String value, Type type) {
        this(value, type, null, null);
    }

    public Literal(String value, Type type, Position pos, ErrorCollector ec) {
        super(type, pos, ec);
        this.value = value;
    }

    public Literal(String value) {
        this(value, Type.STRING);
    }

    public Literal(boolean value) {
        this(value ? "TRUE" : "FALSE", Type.BOOL);
    }

    public Literal(long value) {
        this(Long.toString(value), value > Integer.MAX_VALUE || value < Integer.MIN_VALUE ? NumericType._long_ : NumericType._int_);
    }

    public Literal(double value) {
        this(Double.toString(value), value <= 3.4028234663852886E38 && value >= (double)1.4E-45f || value == 0.0 || value == Double.NaN || value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY ? NumericType._float_ : NumericType._double_);
    }

    public Literal(BigDecimal value) {
        this(value.toString(), NumericType.BigDecimal);
    }

    public boolean isLiteral() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.type == Type.STRING ? "'" + this.value + "'" : this.value;
    }
}

