/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.InputParameter;
import com.sap.ejbql.tree.Literal;
import com.sap.ejbql.tree.PathExpression;

public class LikeExpression
extends ConditionalExpression {
    PathExpression value;
    Expression patternValue;
    Expression escapeCharacter;
    boolean negated;

    public LikeExpression(PathExpression path, Literal pattern) {
        this(path, pattern, null);
    }

    public LikeExpression(PathExpression path, Literal pattern, Position pos) {
        super(pos, (ErrorCollector)(path == null ? (pattern == null ? null : pattern.errColl) : path.errColl));
        this.initializeFrom(path, pattern);
    }

    public LikeExpression(PathExpression path, InputParameter pattern) {
        this(path, pattern, null);
    }

    public LikeExpression(PathExpression path, InputParameter pattern, Position pos) {
        super(pos, (ErrorCollector)(path == null ? (pattern == null ? null : pattern.errColl) : path.errColl));
        this.initializeFrom(path, pattern);
    }

    public void setEscape(Literal escape) {
        if (escape == null) {
            throw new IllegalArgumentException("'escape' not defined");
        }
        if (!escape.type.isString()) {
            this.error(escape.pos, "Escape literal is not of string type (" + escape.type + ")");
        } else if (escape.value.length() != 1) {
            this.error(escape.pos, "Escape literal not of length 1");
        }
        this.escapeCharacter = escape;
    }

    public void setEscape(InputParameter escape) {
        if (escape == null) {
            throw new IllegalArgumentException("'escape' not defined");
        }
        if (!escape.type.isCharacter()) {
            this.error(escape.pos, "Escape is not of character type (" + escape.type + ")");
        }
        this.escapeCharacter = escape;
    }

    public void negate() {
        this.negated = !this.negated;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    private void initializeFrom(PathExpression path, Expression pattern) {
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("'pattern' not defined");
        }
        if (!path.isCmpPath()) {
            this.error(path.pos, "Path '" + path + "' is not a CMP path");
        }
        if (!path.type.isString()) {
            this.error(path.pos, "Path '" + path + "' is of wrong type (" + path.type + "), must be (java.lang.String)");
        }
        if (!pattern.type.isString()) {
            this.error(pattern.pos, "Pattern is of wrong type (" + pattern.type + "), must be (java.lang.String)");
        }
        this.value = path;
        this.patternValue = pattern;
        this.escapeCharacter = null;
        this.negated = false;
    }

    public PathExpression getValue() {
        return this.value;
    }

    public Expression getPattern() {
        return this.patternValue;
    }

    public Expression getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        return "" + this.value + (this.negated ? " NOT " : " ") + "LIKE " + this.patternValue + (this.escapeCharacter != null ? "ESCAPE " + this.escapeCharacter : "");
    }
}

