/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.EjbQlException;
import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.tree.TreeNode;
import com.sap.ejbql.tree.Type;
import com.sap.ejbql.tree.TypeManager;
import java.util.ArrayList;
import java.util.Arrays;

public class InputParameterDeclList
extends TreeNode {
    ArrayList paramTypes = new ArrayList();
    private Type[] cachedTypes = null;
    private TypeManager tm = null;

    public InputParameterDeclList(TypeManager tm) {
        this(tm, null);
    }

    public InputParameterDeclList(TypeManager tm, ErrorCollector errColl) {
        super(null, errColl);
        this.tm = tm;
    }

    public InputParameterDeclList(String[] typeNames, TypeManager tm) {
        this(typeNames, tm, null);
    }

    public InputParameterDeclList(String[] typeNames, TypeManager tm, ErrorCollector errColl) {
        this(tm, errColl);
        if (typeNames != null) {
            int i = 0;
            while (i < typeNames.length) {
                this.addInputParameter(typeNames[i]);
                ++i;
            }
        }
    }

    public InputParameterDeclList(Type[] types, TypeManager tm) {
        this(tm);
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                this.addInputParameter(types[i]);
                ++i;
            }
        }
    }

    public void addInputParameter(String typeName) {
        if (this.tm == null) {
            throw new EjbQlException("No type manager to determine type");
        }
        if (!this.tm.hasType(typeName)) {
            int parNo = this.paramTypes.size() + 1;
            this.error("Declaration of input parameter '?" + parNo + "' of unknown type (" + typeName + ")");
            this.addInputParameter(Type.UNKNOWN);
            return;
        }
        this.addInputParameter(this.tm.getType(typeName));
    }

    public void addInputParameter(Type type) {
        this.cachedTypes = null;
        this.paramTypes.add(type);
    }

    public boolean hasInputParameter(int i) {
        return i > 0 && i <= this.paramTypes.size();
    }

    public Type getInputParameterType(int i) {
        if (!this.hasInputParameter(i)) {
            this.error("Input parameter '?" + i + "' not defined");
            return Type.UNKNOWN;
        }
        return (Type)this.paramTypes.get(i - 1);
    }

    public Type[] getInputParameterTypes() {
        if (this.cachedTypes != null) {
            return this.cachedTypes;
        }
        this.cachedTypes = new Type[this.paramTypes.size()];
        this.paramTypes.toArray(this.cachedTypes);
        return this.cachedTypes;
    }

    public TypeManager getTypeManager() {
        return this.tm;
    }

    public boolean equals(InputParameterDeclList other) {
        return this.tm == other.getTypeManager() && Arrays.equals(this.getInputParameterTypes(), other.getInputParameterTypes());
    }
}

