/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.InputParameter;
import com.sap.ejbql.tree.Literal;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Type;
import java.util.ArrayList;

public class InExpression
extends ConditionalExpression {
    PathExpression path;
    ArrayList expressionList;
    boolean negated;
    private Expression[] cachedExpressionList;

    public InExpression(PathExpression path, Literal lit) {
        this(path, lit, null);
    }

    public InExpression(PathExpression path, Literal lit, Position pos) {
        super(pos, (ErrorCollector)(path == null ? (lit == null ? null : lit.errColl) : path.errColl));
        this.initializeFrom(path, lit);
    }

    public InExpression(PathExpression path, InputParameter input) {
        this(path, input, null);
    }

    public InExpression(PathExpression path, InputParameter input, Position pos) {
        super(pos, (ErrorCollector)(path == null ? (input == null ? null : input.errColl) : path.errColl));
        this.initializeFrom(path, input);
    }

    public InExpression(PathExpression path, Literal[] literals) {
        super(null, null);
        this.initializeFrom(path, literals);
    }

    public InExpression(PathExpression path, InputParameter[] inputs) {
        super(null, null);
        this.initializeFrom(path, inputs);
    }

    public void addListElement(Literal lit) {
        if (lit == null) {
            throw new IllegalArgumentException("'lit' not defined");
        }
        this.addListElement((Expression)lit);
    }

    public void addListElement(InputParameter inp) {
        if (inp == null) {
            throw new IllegalArgumentException("'inp' not defined");
        }
        this.addListElement((Expression)inp);
    }

    public void negate() {
        this.negated = !this.negated;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    private void initializeFrom(PathExpression path, Expression e) {
        if (!path.isCmpPath()) {
            this.error(path.pos, "Path '" + path + "' is not a CMP path");
            return;
        }
        Type pathType = path.type;
        if (!pathType.isNumeric() && !pathType.isString()) {
            this.error("Left hand side of IN expression is of improper type (" + pathType + ")");
        }
        this.path = path;
        this.negated = false;
        this.expressionList = new ArrayList();
        this.addListElement(e);
    }

    private void initializeFrom(PathExpression path, Expression[] e) {
        if (e == null || e.length < 1) {
            this.error("An IN expression needs at least one list element");
            return;
        }
        this.initializeFrom(path, e[0]);
        int i = 1;
        while (i < e.length) {
            this.addListElement(e[i]);
            ++i;
        }
    }

    private void addListElement(Expression e) {
        Type eType = e.type;
        Type pathType = this.path.type;
        if (!(eType == pathType || pathType.isNumeric() && eType.isNumeric() || eType == Type.UNKNOWN || pathType == Type.UNKNOWN)) {
            this.error(e.pos, "Type of list element (" + eType + ") in IN expression is incompatible to type of left hand" + " side (" + pathType + ")");
        }
        this.cachedExpressionList = null;
        this.expressionList.add(e);
    }

    public PathExpression getPath() {
        return this.path;
    }

    public Expression[] getExpressionList() {
        if (this.cachedExpressionList != null) {
            return this.cachedExpressionList;
        }
        this.cachedExpressionList = new Expression[this.expressionList.size()];
        this.expressionList.toArray(this.cachedExpressionList);
        return this.cachedExpressionList;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(256);
        str.append(this.path.toString() + (this.negated ? " NOT IN (" : " IN ("));
        int len = this.expressionList.size();
        if (len > 0) {
            str.append(this.expressionList.get(0).toString());
        }
        int i = 1;
        while (i < len) {
            str.append(", " + this.expressionList.get(i).toString());
            ++i;
        }
        str.append(")");
        return str.toString();
    }
}

