/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.EjbQlException;
import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.IdVarDeclaration;

public class IdentificationVariable
extends Expression {
    String name;
    String normalizedName;
    IdVarDeclaration declaration;

    public IdentificationVariable(String name) {
        this(name, null, null);
    }

    public IdentificationVariable(String name, Position pos, ErrorCollector ec) {
        super(null, pos, ec);
        this.name = name;
        this.normalizedName = name.toLowerCase();
        this.declaration = null;
    }

    public IdentificationVariable(IdVarDeclaration decl) {
        super(null, null, null);
        if (decl == null) {
            throw new IllegalArgumentException("'decl' not defined");
        }
        this.name = decl.name;
        this.normalizedName = decl.normalizedName;
        this.declaration = decl;
        this.type = decl.type;
    }

    public IdentificationVariable(String name, IdVarDeclaration decl) {
        this(decl);
        if (decl != null && !decl.normalizedName.equals(this.normalizedName)) {
            throw new EjbQlException("Variable name '" + name + "' different from declared name (" + decl.name + ")");
        }
    }

    public IdentificationVariable(String name, IdVarDeclaration[] declarations) {
        this(name, declarations, null, null);
    }

    public IdentificationVariable(String name, IdVarDeclaration[] declarations, Position pos, ErrorCollector ec) {
        this(name, pos, ec);
        this.check(declarations);
    }

    public String getName() {
        return this.name;
    }

    public IdVarDeclaration getDeclaration() {
        return this.declaration;
    }

    public boolean isIdentificationVariable() {
        return true;
    }

    public void check(IdVarDeclaration[] declarations) {
        if (declarations == null) {
            throw new IllegalArgumentException("'declarations' not defined");
        }
        int i = 0;
        while (i < declarations.length) {
            IdVarDeclaration decl = declarations[i];
            if (this.normalizedName.equals(decl.normalizedName)) {
                this.declaration = decl;
                this.type = decl.type;
                return;
            }
            ++i;
        }
        this.error("Variable '" + this.name + "' not declared");
    }

    public String toString() {
        return this.normalizedName;
    }
}

