/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.SchemaManager;
import com.sap.ejbql.tree.AbstractSchemaType;
import com.sap.ejbql.tree.TreeNode;
import com.sap.ejbql.tree.Type;
import com.sap.ejbql.tree.TypeManager;

public class IdVarDeclaration
extends TreeNode {
    String name;
    String normalizedName;
    Type type;

    protected IdVarDeclaration(String varName, Position pos, ErrorCollector ec) {
        super(pos, ec);
        this.initializeFrom(varName, Type.UNKNOWN, null);
    }

    public IdVarDeclaration(String varName, AbstractSchemaType schemaType) {
        super(null, null);
        if (schemaType == null) {
            throw new IllegalArgumentException("'schemaType' not defined");
        }
        this.initializeFrom(varName, schemaType, schemaType.tm);
    }

    public IdVarDeclaration(String varName, String schemaName, TypeManager tm) {
        super(null, null);
        if (tm == null) {
            throw new IllegalArgumentException("'tm' not defined");
        }
        Type schemaType = Type.UNKNOWN;
        if (!tm.hasAbstractSchemaType(schemaName)) {
            this.error("Abstract Schema Type '" + schemaName + "' doesn't exist");
        } else {
            schemaType = tm.getAbstractSchemaType(schemaName);
        }
        this.initializeFrom(varName, schemaType, tm);
    }

    public IdVarDeclaration(String varName, AbstractSchemaName schemaName, Position pos) {
        super(pos, schemaName.errColl);
        this.initializeFrom(varName, schemaName.type, schemaName.tm);
    }

    protected void initializeFrom(String varName, Type schemaType, TypeManager tm) {
        if (varName == null) {
            throw new IllegalArgumentException("'varName' not defined");
        }
        if (tm != null) {
            SchemaManager sm = tm.sm;
            if (sm.beanExists(varName)) {
                this.error("Variable must not have same name as abstract schema name (" + varName + ")");
            } else if (sm.isEjbName(varName)) {
                this.error("Variable must not have ejb-name (" + varName + ")");
            }
        }
        this.name = varName;
        this.normalizedName = varName.toLowerCase();
        this.type = schemaType == null ? Type.UNKNOWN : schemaType;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "" + this.type + " " + this.normalizedName;
    }

    public static class AbstractSchemaName
    extends TreeNode {
        String name;
        AbstractSchemaType type;
        TypeManager tm;

        public AbstractSchemaName(String schemaName, TypeManager tm, Position pos, ErrorCollector errColl) {
            super(pos, errColl);
            this.name = schemaName;
            this.tm = tm;
            if (!tm.hasAbstractSchemaType(this.name)) {
                this.error("Abstract Schema Type '" + schemaName + "' doesn't exist");
            } else {
                this.type = tm.getAbstractSchemaType(this.name);
            }
        }
    }
}

