/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.Position;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.PathExpression;

public class EmptyCollectionExpression
extends ConditionalExpression {
    PathExpression collectionValuedPath;
    boolean negated;

    public EmptyCollectionExpression(PathExpression path) {
        this(path, null);
    }

    public EmptyCollectionExpression(PathExpression path, Position pos) {
        super(pos, path == null ? null : path.errColl);
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        if (!path.isCollectionValued()) {
            this.error(path.pos, "Path '" + path + "' is not collection-valued");
        }
        this.collectionValuedPath = path;
    }

    public void negate() {
        this.negated = !this.negated;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    public PathExpression getPath() {
        return this.collectionValuedPath;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        return "" + this.collectionValuedPath + (this.negated ? " IS NOT EMPTY" : " IS EMPTY");
    }
}

