/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.ConditionalExpression;

public class ConditionalCombination
extends ConditionalExpression {
    Operator operator;
    ConditionalExpression leftOperand;
    ConditionalExpression rightOperand;

    public ConditionalCombination(MonadicOperator op, ConditionalExpression operand) {
        this(op, operand, null);
    }

    public ConditionalCombination(MonadicOperator op, ConditionalExpression operand, Position pos) {
        super(pos, operand == null ? null : operand.errColl);
        if (op == null) {
            throw new IllegalArgumentException("'op' not defined");
        }
        if (operand == null) {
            throw new IllegalArgumentException("'operand' not defined");
        }
        this.operator = op;
        this.leftOperand = operand;
        this.rightOperand = null;
    }

    public ConditionalCombination(DyadicOperator op, ConditionalExpression left, ConditionalExpression right) {
        this(op, left, right, null);
    }

    public ConditionalCombination(DyadicOperator op, ConditionalExpression left, ConditionalExpression right, Position pos) {
        super(pos, (ErrorCollector)(left == null ? (right == null ? null : right.errColl) : left.errColl));
        if (op == null) {
            throw new IllegalArgumentException("'op' not defined");
        }
        if (left == null) {
            throw new IllegalArgumentException("'left' not defined");
        }
        if (right == null) {
            throw new IllegalArgumentException("'right' not defined");
        }
        this.operator = op;
        this.leftOperand = left;
        this.rightOperand = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public ConditionalExpression getLeftOperand() {
        return this.leftOperand;
    }

    public ConditionalExpression getRightOperand() {
        return this.rightOperand;
    }

    public String toString() {
        return "" + (this.rightOperand == null ? this.operator + " " + this.leftOperand : this.leftOperand + " " + this.operator + " " + this.rightOperand);
    }

    public static class DyadicOperator
    extends Operator {
        public static final DyadicOperator AND = new DyadicOperator("AND");
        public static final DyadicOperator OR = new DyadicOperator("OR");

        private DyadicOperator(String val) {
            super(val);
        }
    }

    public static class MonadicOperator
    extends Operator {
        public static final MonadicOperator NOT = new MonadicOperator("NOT");

        private MonadicOperator(String val) {
            super(val);
        }
    }

    public static class Operator {
        private String printableRepresentation;

        private Operator(String val) {
            this.printableRepresentation = val;
        }

        public String toString() {
            return this.printableRepresentation;
        }
    }
}

