/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.BuiltinFunction;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.IdentificationVariable;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Type;

public class ComparisonExpression
extends ConditionalExpression {
    Operator operator;
    Expression leftOperand;
    Expression rightOperand;

    public ComparisonExpression(Operator op, PathExpression path, Expression right) {
        this(op, path, right, null);
    }

    public ComparisonExpression(Operator op, PathExpression path, Expression right, Position pos) {
        super(pos, (ErrorCollector)(path == null ? (right == null ? null : right.errColl) : path.errColl));
        if (op == null) {
            throw new IllegalArgumentException("'op' not defined");
        }
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        if (right == null) {
            throw new IllegalArgumentException("'right' not defined");
        }
        if (!path.isSingleValued()) {
            this.error(path.pos, "Path '" + path + "' is not single-valued");
        }
        this.initializeFrom(op, path, right);
    }

    public ComparisonExpression(Operator op, IdentificationVariable left, Expression right) {
        this(op, left, right, null);
    }

    public ComparisonExpression(Operator op, IdentificationVariable left, Expression right, Position pos) {
        super(pos, (ErrorCollector)(left == null ? (right == null ? null : right.errColl) : left.errColl));
        if (op == null) {
            throw new IllegalArgumentException("'op' not defined");
        }
        if (left == null) {
            throw new IllegalArgumentException("'left' not defined");
        }
        if (right == null) {
            throw new IllegalArgumentException("'right' not defined");
        }
        this.initializeFrom(op, left, right);
    }

    public ComparisonExpression(Operator op, IdVarDeclaration decl, Expression right) {
        this(op, new IdentificationVariable(decl), right);
    }

    public ComparisonExpression(Operator op, BuiltinFunction left, Expression right) {
        this(op, left, right, null);
    }

    public ComparisonExpression(Operator op, BuiltinFunction left, Expression right, Position pos) {
        super(pos, (ErrorCollector)(left == null ? (right == null ? null : right.errColl) : left.errColl));
        if (op == null) {
            throw new IllegalArgumentException("'op' not defined");
        }
        if (left == null) {
            throw new IllegalArgumentException("'left' not defined");
        }
        if (right == null) {
            throw new IllegalArgumentException("'right' not defined");
        }
        this.initializeFrom(op, left, right);
    }

    private void initializeFrom(Operator op, Expression left, Expression right) {
        Type leftType = left.type;
        Type rightType = right.type;
        if (leftType != Type.UNKNOWN) {
            if (leftType.isBoolean() && op != Operator.EQUAL && op != Operator.UNEQUAL) {
                this.error("Comparison '" + op + "' not defined for boolean types");
            }
            if (leftType.isEntityBean() && op != Operator.EQUAL && op != Operator.UNEQUAL) {
                this.error("Comparison '" + op + "' not defined for entity beans");
            }
        }
        if (leftType.isDependentObject() || rightType.isDependentObject()) {
            this.error("Comparison '" + op + "' not defined for dependent objects");
        }
        if (!(leftType == rightType || leftType.isNumeric() && rightType.isNumeric() || leftType.isString() && rightType.isString() || leftType.isBoolean() && rightType.isBoolean() || leftType.isDate() && rightType.isDate() || leftType == Type.UNKNOWN || rightType == Type.UNKNOWN)) {
            this.error("Comparison of incompatible types: (" + leftType + ") '" + op + "' (" + rightType + ")");
        }
        this.operator = op;
        this.leftOperand = left;
        this.rightOperand = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeftOperand() {
        return this.leftOperand;
    }

    public Expression getRightOperand() {
        return this.rightOperand;
    }

    public String toString() {
        return "" + this.leftOperand + " " + this.operator + " " + this.rightOperand;
    }

    public static class Operator {
        public static final Operator LESS = new Operator("<");
        public static final Operator GREATER = new Operator(">");
        public static final Operator LESS_EQUAL = new Operator("<=");
        public static final Operator GREATER_EQUAL = new Operator(">=");
        public static final Operator EQUAL = new Operator("=");
        public static final Operator UNEQUAL = new Operator("<>");
        private String printableRepresentation;

        private Operator(String val) {
            this.printableRepresentation = val;
        }

        public String toString() {
            return this.printableRepresentation;
        }
    }
}

