/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.IdentificationVariable;
import com.sap.ejbql.tree.InputParameter;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Type;

public class CollectionMemberExpression
extends ConditionalExpression {
    Expression value;
    PathExpression collectionValuedPath;
    boolean negated;

    public CollectionMemberExpression(PathExpression val, PathExpression path) {
        this(val, path, null);
    }

    public CollectionMemberExpression(PathExpression val, PathExpression path, Position pos) {
        super(pos, (ErrorCollector)(val == null ? (path == null ? null : path.errColl) : val.errColl));
        if (val == null) {
            throw new IllegalArgumentException("'val' not defined");
        }
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        this.initializeFrom(val, path);
    }

    public CollectionMemberExpression(IdentificationVariable idvar, PathExpression path) {
        this(idvar, path, null);
    }

    public CollectionMemberExpression(IdentificationVariable idvar, PathExpression path, Position pos) {
        super(pos, (ErrorCollector)(idvar == null ? (path == null ? null : path.errColl) : idvar.errColl));
        if (idvar == null) {
            throw new IllegalArgumentException("'idvar' not defined");
        }
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        this.initializeFrom(idvar, path);
    }

    public CollectionMemberExpression(IdVarDeclaration decl, PathExpression path) {
        this(new IdentificationVariable(decl), path);
    }

    public CollectionMemberExpression(InputParameter inp, PathExpression path) {
        this(inp, path, null);
    }

    public CollectionMemberExpression(InputParameter inp, PathExpression path, Position pos) {
        super(pos, (ErrorCollector)(inp == null ? (path == null ? null : path.errColl) : inp.errColl));
        if (inp == null) {
            throw new IllegalArgumentException("'inp' not defined");
        }
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        this.initializeFrom(inp, path);
    }

    public void negate() {
        this.negated = !this.negated;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    private void initializeFrom(PathExpression vPath, PathExpression path) {
        if (!vPath.isCmrPath()) {
            this.error(vPath.pos, "Path '" + vPath + "' does not denote a relation");
        }
        if (!vPath.isSingleValued()) {
            this.error(vPath.pos, "Path '" + vPath + "' is not single-valued");
        }
        this.initializeFrom((Expression)vPath, path);
    }

    private void initializeFrom(Expression v, PathExpression path) {
        if (!path.isCollectionValued()) {
            this.error(path.pos, "Path '" + path + "' is not collection-valued");
        }
        if (v.type != path.type && v.type != Type.UNKNOWN && path.type != Type.UNKNOWN) {
            this.error("Type of left hand side of MEMBER expression (" + v.type + ") different from type of collection elements (" + path.type + ")");
        }
        this.value = v;
        this.collectionValuedPath = path;
        this.negated = false;
    }

    public Expression getValue() {
        return this.value;
    }

    public PathExpression getPath() {
        return this.collectionValuedPath;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        return "" + this.value + (this.negated ? " NOT " : " ") + "MEMBER OF " + this.collectionValuedPath;
    }
}

