/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.AbstractSchemaType;
import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Type;
import com.sap.ejbql.tree.TypeManager;

public class CollectionMemberDeclaration
extends IdVarDeclaration {
    PathExpression path;

    public CollectionMemberDeclaration(String name, PathExpression path) {
        super(name, (Position)null, (ErrorCollector)null);
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        if (!path.isCollectionValued()) {
            this.error(path.pos, "Path '" + path + "' is not collection-valued");
        }
        if (path.type != Type.UNKNOWN && path.type.isEntityBean()) {
            AbstractSchemaType asType = (AbstractSchemaType)path.type;
            this.initializeFrom(name, asType, asType.tm);
        }
        this.path = path;
    }

    public CollectionMemberDeclaration(String name, PathExpression path, TypeManager tm) {
        this(name, path, tm, null);
    }

    public CollectionMemberDeclaration(String name, PathExpression path, TypeManager tm, Position pos) {
        super(name, pos, path == null ? null : path.errColl);
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        if (!path.isCollectionValued()) {
            this.error(path.pos, "Path '" + path + "' is not collection-valued");
        }
        this.initializeFrom(name, path.type, tm);
        this.path = path;
    }

    public PathExpression getPath() {
        return this.path;
    }

    public String toString() {
        return "IN (" + this.path + ") " + this.normalizedName;
    }
}

