/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.BuiltinFunction;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.NumericType;
import com.sap.ejbql.tree.Type;

public class BuiltinSUBSTRING
extends BuiltinFunction {
    Expression sourceString;
    Expression start;
    Expression length;

    public BuiltinSUBSTRING(Expression arg1, Expression arg2, Expression arg3) {
        this(arg1, arg2, arg3, null);
    }

    public BuiltinSUBSTRING(Expression arg1, Expression arg2, Expression arg3, Position pos) {
        super(Type.STRING, pos, (ErrorCollector)(arg1 == null ? (arg2 == null ? (arg3 == null ? null : arg3.errColl) : arg2.errColl) : arg1.errColl));
        if (arg1 == null) {
            throw new IllegalArgumentException("'arg1' not defined");
        }
        if (arg2 == null) {
            throw new IllegalArgumentException("'arg2' not defined");
        }
        if (arg3 == null) {
            throw new IllegalArgumentException("'arg3' not defined");
        }
        if (!arg1.type.isString()) {
            this.error(arg1.pos, "First parameter of SUBSTRING not of string type (" + arg1.type + ")");
        }
        if (!arg2.type.isConvertibleTo(NumericType.Integer)) {
            this.error(arg2.pos, "Second parameter of SUBSTRING not of integer type (" + arg2.type + ")");
        }
        if (!arg3.type.isConvertibleTo(NumericType.Integer)) {
            this.error(arg3.pos, "Third parameter of SUBSTRING not of integer type (" + arg3.type + ")");
        }
        this.sourceString = arg1;
        this.start = arg2;
        this.length = arg3;
    }

    public Expression getSourceString() {
        return this.sourceString;
    }

    public Expression getStart() {
        return this.start;
    }

    public Expression getLength() {
        return this.length;
    }

    public String toString() {
        return "SUBSTRING(" + this.sourceString + ", " + this.start + ", " + this.length + ")";
    }
}

