/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.BuiltinFunction;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.NumericType;
import com.sap.ejbql.tree.Type;

public class BuiltinMOD
extends BuiltinFunction {
    Expression dividend;
    Expression divisor;

    public BuiltinMOD(Expression arg1, Expression arg2) {
        this(arg1, arg2, null);
    }

    public BuiltinMOD(Expression arg1, Expression arg2, Position pos) {
        super(Type.INT, pos, (ErrorCollector)(arg1 == null ? (arg2 == null ? null : arg2.errColl) : arg1.errColl));
        if (arg1 == null) {
            throw new IllegalArgumentException("'arg1' not defined");
        }
        if (arg2 == null) {
            throw new IllegalArgumentException("'arg2' not defined");
        }
        if (!arg1.type.isConvertibleTo(NumericType.Integer)) {
            this.error(arg1.pos, "First parameter of MOD not of integer type (" + arg1.type + ")");
        }
        if (!arg2.type.isConvertibleTo(NumericType.Integer)) {
            this.error(arg2.pos, "Second parameter of MOD not of integer type (" + arg2.type + ")");
        }
        this.dividend = arg1;
        this.divisor = arg2;
    }

    public Expression getDividend() {
        return this.dividend;
    }

    public Expression getDivisor() {
        return this.divisor;
    }

    public String toString() {
        return "MOD(" + this.dividend + ", " + this.divisor + ")";
    }
}

