/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.BuiltinFunction;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.Type;

public class BuiltinCONCAT
extends BuiltinFunction {
    Expression leftString;
    Expression rightString;

    public BuiltinCONCAT(Expression left, Expression right) {
        this(left, right, null);
    }

    public BuiltinCONCAT(Expression left, Expression right, Position pos) {
        super(Type.STRING, pos, (ErrorCollector)(left == null ? (right == null ? null : right.errColl) : left.errColl));
        if (left == null) {
            throw new IllegalArgumentException("'left' not defined");
        }
        if (right == null) {
            throw new IllegalArgumentException("'right' not defined");
        }
        if (!left.type.isString()) {
            this.error(left.pos, "First argument of CONCAT not of string type (" + left.type + ")");
        }
        if (!right.type.isString()) {
            this.error(right.pos, "Second argument of CONCAT not of string type (" + right.type + ")");
        }
        this.leftString = left;
        this.rightString = right;
    }

    public Expression getLeftString() {
        return this.leftString;
    }

    public Expression getRightString() {
        return this.rightString;
    }

    public String toString() {
        return "CONCAT(" + this.leftString + ", " + this.rightString + ")";
    }
}

