/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.BuiltinFunction;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Type;

public class BetweenExpression
extends ConditionalExpression {
    Expression value;
    Expression lowerBound;
    Expression upperBound;
    boolean negated;

    public BetweenExpression(PathExpression path, Expression lbd, Expression ubd) {
        this(path, lbd, ubd, null);
    }

    public BetweenExpression(PathExpression path, Expression lbd, Expression ubd, Position pos) {
        super(pos, (ErrorCollector)(path == null ? (lbd == null ? (ubd == null ? null : ubd.errColl) : lbd.errColl) : path.errColl));
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        if (lbd == null) {
            throw new IllegalArgumentException("'lbd' not defined");
        }
        if (ubd == null) {
            throw new IllegalArgumentException("'ubd' not defined");
        }
        if (!path.isCmpPath()) {
            this.error(path.pos, "Path '" + path + "' is not a CMP path");
        }
        this.initializeFrom(path, lbd, ubd);
    }

    public BetweenExpression(BuiltinFunction fct, Expression lbd, Expression ubd) {
        this(fct, lbd, ubd, null);
    }

    public BetweenExpression(BuiltinFunction fct, Expression lbd, Expression ubd, Position pos) {
        super(pos, (ErrorCollector)(fct == null ? (lbd == null ? (ubd == null ? null : ubd.errColl) : lbd.errColl) : fct.errColl));
        if (fct == null) {
            throw new IllegalArgumentException("'fct' not defined");
        }
        if (lbd == null) {
            throw new IllegalArgumentException("'lbd' not defined");
        }
        if (ubd == null) {
            throw new IllegalArgumentException("'ubd' not defined");
        }
        this.initializeFrom(fct, lbd, ubd);
    }

    public void negate() {
        this.negated = !this.negated;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    private void initializeFrom(Expression v, Expression lbd, Expression ubd) {
        Type vType = v.type;
        Type lbdType = lbd.type;
        Type ubdType = ubd.type;
        if (vType != Type.UNKNOWN && !vType.isNumeric() && !vType.isString()) {
            this.error("Left hand side of BETWEEN expression is of improper type (" + vType + ")");
        }
        if (!(lbdType == vType || lbdType.isNumeric() && vType.isNumeric() || vType == Type.UNKNOWN || lbdType == Type.UNKNOWN)) {
            this.error("Type of lower bound (" + lbdType + ") in BETWEEN expression" + " is incompatible to type of left hand side (" + vType + ")");
        }
        if (!(ubdType == vType || ubdType.isNumeric() && vType.isNumeric() || vType == Type.UNKNOWN || ubdType == Type.UNKNOWN)) {
            this.error("Type of upper bound (" + ubdType + ") in BETWEEN expression" + " is incompatible to type of left hand side (" + vType + ")");
        }
        this.value = v;
        this.lowerBound = lbd;
        this.upperBound = ubd;
        this.negated = false;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getLowerBound() {
        return this.lowerBound;
    }

    public Expression getUpperBound() {
        return this.upperBound;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        return "" + this.value + (this.negated ? " NOT " : " ") + "BETWEEN " + this.lowerBound + " AND " + this.upperBound;
    }
}

