/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.NumericType;
import com.sap.ejbql.tree.Type;

public class ArithmeticExpression
extends Expression {
    Operator operator;
    Expression leftOperand;
    Expression rightOperand;

    public ArithmeticExpression(MonadicOperator op, Expression operand) {
        this(op, operand, null);
    }

    public ArithmeticExpression(MonadicOperator op, Expression operand, Position pos) {
        super(Type.UNKNOWN, pos, operand == null ? null : operand.errColl);
        if (op == null) {
            throw new IllegalArgumentException("Operator 'op' not defined");
        }
        if (operand == null) {
            throw new IllegalArgumentException("'operand' not defined");
        }
        Type operandType = operand.type;
        if (operandType == Type.UNKNOWN) {
            return;
        }
        if (!operandType.isNumeric()) {
            this.error(operand.pos, "Operand not of numeric type (" + operandType + ")");
        } else {
            this.type = NumericType.unaryPromotion((NumericType)operandType);
        }
        this.operator = op;
        this.leftOperand = operand;
        this.rightOperand = null;
    }

    public ArithmeticExpression(DyadicOperator op, Expression left, Expression right) {
        this(op, left, right, null);
    }

    public ArithmeticExpression(DyadicOperator op, Expression left, Expression right, Position pos) {
        super(Type.UNKNOWN, pos, (ErrorCollector)(left == null ? (right == null ? null : right.errColl) : left.errColl));
        if (op == null) {
            throw new IllegalArgumentException("Operator 'op' not defined");
        }
        if (left == null) {
            throw new IllegalArgumentException("Operand 'left' not defined");
        }
        if (right == null) {
            throw new IllegalArgumentException("Operand 'right' not defined");
        }
        Type leftOperandType = left.type;
        Type rightOperandType = right.type;
        if (leftOperandType == Type.UNKNOWN || rightOperandType == Type.UNKNOWN) {
            return;
        }
        boolean leftIsNumeric = leftOperandType.isNumeric();
        boolean rightIsNumeric = rightOperandType.isNumeric();
        if (!leftIsNumeric) {
            this.error("Left operand of '" + op + "' not of numeric type (" + leftOperandType + ")");
        }
        if (!rightIsNumeric) {
            this.error("Right operand of '" + op + "' not of numeric type (" + rightOperandType + ")");
        }
        if (leftIsNumeric && rightIsNumeric) {
            this.type = NumericType.binaryPromotion((NumericType)leftOperandType, (NumericType)rightOperandType);
        }
        this.operator = op;
        this.leftOperand = left;
        this.rightOperand = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeftOperand() {
        return this.leftOperand;
    }

    public Expression getRightOperand() {
        return this.rightOperand;
    }

    public String toString() {
        return "" + (this.rightOperand == null ? this.operator + "" + this.leftOperand : this.leftOperand + " " + this.operator + " " + this.rightOperand);
    }

    public static class DyadicOperator
    extends Operator {
        public static final DyadicOperator PLUS = new DyadicOperator("+");
        public static final DyadicOperator MINUS = new DyadicOperator("-");
        public static final DyadicOperator TIMES = new DyadicOperator("*");
        public static final DyadicOperator DIVIDE = new DyadicOperator("/");

        private DyadicOperator(String val) {
            super(val);
        }
    }

    public static class MonadicOperator
    extends Operator {
        public static final MonadicOperator PLUS = new MonadicOperator("+");
        public static final MonadicOperator MINUS = new MonadicOperator("-");

        private MonadicOperator(String val) {
            super(val);
        }
    }

    public static class Operator {
        private String printableRepresentation;

        private Operator(String val) {
            this.printableRepresentation = val;
        }

        public String toString() {
            return this.printableRepresentation;
        }
    }
}

