/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.Position;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.NumericType;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.SelectAggregate;
import com.sap.ejbql.tree.Type;

public class AggregateSUM
extends SelectAggregate {
    PathExpression path;

    public AggregateSUM(PathExpression path) {
        this(path, false);
    }

    public AggregateSUM(PathExpression path, boolean distinct) {
        this(path, distinct, null);
    }

    public AggregateSUM(PathExpression path, boolean distinct, Position pos) {
        super(pos, path == null ? null : path.errColl);
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        this.path = path;
        this.distinct = distinct;
        if (path.type != Type.UNKNOWN) {
            this.checkPath();
        }
    }

    public PathExpression getPath() {
        return this.path;
    }

    public Expression getAggregand() {
        return this.path;
    }

    public void check(IdVarDeclaration[] declarations) {
        this.path.check(declarations);
        this.checkPath();
    }

    public void checkPath() {
        Type pathType;
        if (!this.path.isCmpPath()) {
            this.error(this.path.pos, "Path '" + this.path + "' is not a CMP path");
        }
        if ((pathType = this.path.type) == Type.UNKNOWN) {
            return;
        }
        if (pathType.isNumeric()) {
            this.returnType = NumericType.unaryPromotion((NumericType)pathType);
        } else {
            this.error(this.path.pos, "Path '" + this.path + "' is not of numeric type (" + pathType + ")");
        }
    }

    public String toString() {
        return "SUM(" + (this.distinct ? "DISTINCT " : "") + this.path + ")";
    }
}

