/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.EjbQlException;
import com.sap.ejbql.tree.Type;
import com.sap.ejbql.tree.TypeManager;

public class AbstractSchemaType
extends Type {
    TypeManager tm;

    AbstractSchemaType(String name, TypeManager tm) {
        super(name, false);
        if (tm == null) {
            throw new IllegalArgumentException("'tm' not defined");
        }
        if (tm.sm == null) {
            throw new IllegalStateException("Schema manager not defined");
        }
        this.tm = tm;
    }

    public boolean isEntityBean() {
        return true;
    }

    public boolean isDependentObject() {
        return false;
    }

    public boolean hasCmpField(String cmpFieldName) {
        return this.tm.sm.beanHasCmpField(this.name, cmpFieldName);
    }

    public boolean hasCmrField(String cmrFieldName) {
        return this.tm.sm.beanHasCmrField(this.name, cmrFieldName);
    }

    public boolean isSingleValued(String cmrFieldName) {
        return this.tm.sm.isSingleValued(this.name, cmrFieldName);
    }

    public boolean isCollectionValued(String cmrFieldName) {
        return this.tm.sm.isCollectionValued(this.name, cmrFieldName);
    }

    public Type getCmpFieldType(String cmpFieldName) {
        if (!this.hasCmpField(cmpFieldName)) {
            throw new EjbQlException("Type (" + this.name + ") has no field '" + cmpFieldName + "'");
        }
        String fieldTypeName = this.tm.sm.getCmpFieldType(this.name, cmpFieldName);
        if (fieldTypeName == null) {
            throw new EjbQlException("Inconsistency in schema definition: no type information for field '" + cmpFieldName + "' of (" + this.name + ")");
        }
        if (!this.tm.hasJavaType(fieldTypeName)) {
            throw new EjbQlException("Inconsistency in schema definition: cannot find type '" + fieldTypeName + "'");
        }
        return this.tm.getJavaType(fieldTypeName);
    }

    public Type getCmrFieldType(String cmrFieldName) {
        if (!this.hasCmrField(cmrFieldName)) {
            throw new EjbQlException("Type (" + this.name + ") has no relation '" + cmrFieldName + "'");
        }
        if (this.isCollectionValued(cmrFieldName)) {
            String fieldTypeName = this.tm.sm.getCmrFieldType(this.name, cmrFieldName);
            if (fieldTypeName == null) {
                throw new EjbQlException("Inconsistency in schema definition: no type information for relation '" + cmrFieldName + "' of (" + this.name + ")");
            }
            if (!this.tm.hasJavaType(fieldTypeName)) {
                throw new EjbQlException("Inconsistency in schema definition: cannot find type '" + fieldTypeName + "'");
            }
            return this.tm.getJavaType(fieldTypeName);
        }
        return this.getCmrFieldBaseType(cmrFieldName);
    }

    public AbstractSchemaType getCmrFieldBaseType(String cmrFieldName) {
        if (!this.hasCmrField(cmrFieldName)) {
            throw new EjbQlException("Type (" + this.name + ") has no relation '" + cmrFieldName + "'");
        }
        String fieldTypeName = this.tm.sm.getCmrFieldBaseType(this.name, cmrFieldName);
        if (fieldTypeName == null) {
            throw new EjbQlException("Inconsistency in schema definition: no type information for relation '" + cmrFieldName + "' of (" + this.name + ")");
        }
        if (!this.tm.hasAbstractSchemaType(fieldTypeName)) {
            throw new EjbQlException("Inconsistency in schema definition: cannot find abstract schema type '" + fieldTypeName + "'");
        }
        return this.tm.getAbstractSchemaType(fieldTypeName);
    }
}

