/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql;

import com.sap.ejbql.SchemaManager;
import com.sap.ejbql.schema.SchemaManagerImpl;
import com.sap.ejbql.tree.AggregateCOUNT;
import com.sap.ejbql.tree.ComparisonExpression;
import com.sap.ejbql.tree.ConditionalCombination;
import com.sap.ejbql.tree.ConditionalExpression;
import com.sap.ejbql.tree.Expression;
import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.IdentificationVariable;
import com.sap.ejbql.tree.InExpression;
import com.sap.ejbql.tree.InputParameter;
import com.sap.ejbql.tree.Literal;
import com.sap.ejbql.tree.NullComparisonExpression;
import com.sap.ejbql.tree.OrderByItem;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Query;
import com.sap.ejbql.tree.SelectPath;
import com.sap.ejbql.tree.Type;
import com.sap.ejbql.tree.TypeManager;

class Sample {
    public static SchemaManagerImpl sm;
    public static TypeManager tm;

    Sample() {
    }

    public static void main(String[] args) {
        sm = new SchemaManagerImpl();
        sm.buildSchema(args);
        tm = new TypeManager((SchemaManager)sm);
        try {
            Sample.buildSample1();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        try {
            Sample.buildSample2();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void buildSample1() {
        Object op = null;
        Query q = new Query();
        IdVarDeclaration c = new IdVarDeclaration("c", tm.getAbstractSchemaType("Customer"));
        q.addDeclaration(c);
        q.setSelect(new AggregateCOUNT(c, true));
        PathExpression city = new PathExpression(c, new String[]{"account", "contactInfo", "address", "city"});
        q.setWhere(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, city, (Expression)new Literal("Los Angeles")));
        System.out.println("============== Statement ====================");
        System.out.println(q.toString());
    }

    private static void buildSample2() {
        Object opEqual = null;
        Object opAnd = null;
        Type[] inputParams = new Type[]{tm.getJavaType("java.lang.String")};
        IdVarDeclaration a = new IdVarDeclaration("a", tm.getAbstractSchemaType("Account"));
        IdVarDeclaration c = new IdVarDeclaration("c", tm.getAbstractSchemaType("Customer"));
        Query q = new Query(new IdVarDeclaration[]{a, c});
        PathExpression contactInfo = new PathExpression(a);
        contactInfo.addComponent("contactInfo");
        PathExpression givenName = new PathExpression(a, new String[]{"contactInfo", "givenName"});
        PathExpression familyName = new PathExpression(a, new String[]{"contactInfo", "familyName"});
        q.setSelect(new SelectPath(contactInfo));
        ComparisonExpression e1 = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, new IdentificationVariable(a), (Expression)new PathExpression(c, new String[]{"account"}));
        InExpression e2 = new InExpression(givenName, new Literal[]{new Literal("Charly"), new Literal("Marcy"), new Literal("Lucy")});
        e2.addListElement(new InputParameter(1, inputParams));
        NullComparisonExpression e3 = new NullComparisonExpression(new PathExpression(a, new String[]{"creditCard"}));
        e3.negate();
        q.setWhere(new ConditionalCombination(ConditionalCombination.DyadicOperator.AND, (ConditionalExpression)e1, new ConditionalCombination(ConditionalCombination.DyadicOperator.AND, (ConditionalExpression)e2, e3)));
        q.addOrderByItem(new OrderByItem(familyName));
        System.out.println("============== Statement ====================");
        System.out.println(q.toString());
    }
}

