/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql;

import com.sap.ejbql.EjbQlException;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.TreeNode;

public class LogEntry
implements Comparable {
    Position position;
    EjbQlException error;
    TreeNode originator;
    public static final Position undefinedPosition = new Position(0, 0);

    public LogEntry(Position p, EjbQlException e, TreeNode o) {
        if (e == null) {
            throw new IllegalArgumentException("'e' not defined");
        }
        this.position = p != null ? p : undefinedPosition;
        this.error = e;
        this.originator = o;
    }

    public int getLine() {
        return this.position.getLine();
    }

    public int getColumn() {
        return this.position.getColumn();
    }

    public Position getPosition() {
        if (this.position == undefinedPosition) {
            return null;
        }
        return this.position;
    }

    public String getErrorMessage() {
        return this.error.getMessage();
    }

    public EjbQlException getError() {
        return this.error;
    }

    public TreeNode getOriginator() {
        return this.originator;
    }

    public String getIndicatorLine() {
        int col = this.getColumn();
        if (col == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer(col);
        int i = 1;
        while (i < col) {
            str.append(' ');
            ++i;
        }
        str.append('^');
        str.append('\n');
        return str.toString();
    }

    public String getIndicatorLine(String s) {
        int col = this.getColumn();
        if (col == 0 || s.length() < col) {
            return "";
        }
        StringBuffer str = new StringBuffer(col);
        int i = 1;
        while (i < col) {
            if (s.charAt(i - 1) != '\t') {
                str.append(' ');
            } else {
                str.append('\t');
            }
            ++i;
        }
        str.append('^');
        str.append('\n');
        return str.toString();
    }

    public int compareTo(Object o) {
        LogEntry other = (LogEntry)o;
        return this.position.compareTo(other.position);
    }
}

