/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql;

import com.sap.ejbql.EjbQlException;
import com.sap.ejbql.LogEntry;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.TreeNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class ErrorCollector {
    Vector errors = new Vector();

    public void logError(Position pos, EjbQlException e, TreeNode o) {
        this.errors.add(new LogEntry(pos, e, o));
    }

    public int getNofErrors() {
        return this.errors.size();
    }

    public String getErrorMessages() {
        return this.getErrorMessages(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public String getErrorMessages(String source) {
        if (this.getNofErrors() == 0) {
            return "";
        }
        ArrayList<void> src = new ArrayList<void>();
        BufferedReader br = new BufferedReader(new StringReader(source));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                void var4_4;
                src.add(var4_4);
            }
            String[] ar = new String[src.size()];
            src.toArray(ar);
            return this.getErrorMessages(ar);
        }
        catch (IOException e) {
            return this.getErrorMessages();
        }
    }

    public String getErrorMessages(String[] source) {
        if (this.getNofErrors() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer(1024);
        DecimalFormat df = new DecimalFormat("##");
        int i = 0;
        while (i < this.errors.size()) {
            LogEntry log = (LogEntry)this.errors.get(i);
            int line = 0;
            if (log.getPosition() != null) {
                line = log.getLine();
                str.append("line " + df.format(line) + ": ");
            }
            str.append(log.error.getMessage());
            str.append("\n");
            if (line > 0 && line <= source.length) {
                String sourceLine = source[line - 1];
                str.append(sourceLine);
                str.append("\n");
                str.append(log.getIndicatorLine(sourceLine));
            }
            ++i;
        }
        return str.toString();
    }

    public LogEntry[] getErrors() {
        LogEntry[] arr = new LogEntry[this.errors.size()];
        this.errors.toArray(arr);
        return arr;
    }

    public LogEntry[] getErrorsSorted() {
        Object[] arr = this.getErrors();
        Arrays.sort(arr);
        return arr;
    }
}

