/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.tree.InputParameterDeclList;
import com.sap.ejbql.tree.Query;
import com.sap.ejbql.tree.Type;
import com.sap.ejbql.tree.TypeManager;

public class EJBQLParsingContext {
    String[] inputParamTypeNames;
    InputParameterDeclList inputParamDeclList;
    String queryString;
    TypeManager tm;
    boolean collectErrors;
    boolean processed;
    ErrorCollector ec;
    Query parseTree;

    public EJBQLParsingContext(TypeManager tm) {
        this(tm, true);
    }

    public EJBQLParsingContext(TypeManager tm, boolean collecting) {
        if (tm == null) {
            throw new IllegalArgumentException("No Typemanager given");
        }
        this.tm = tm;
        this.collectErrors = collecting;
        this.initialize();
    }

    public boolean isCollectingErrors() {
        return this.collectErrors;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public TypeManager getTypeManager() {
        return this.tm;
    }

    public void resetInputParams() {
        this.inputParamTypeNames = null;
        this.inputParamDeclList = null;
    }

    public void setInputParams(String[] params) {
        this.initialize();
        this.resetInputParams();
        this.inputParamTypeNames = params;
    }

    public void setInputParams(InputParameterDeclList params) {
        if (params != null && params.getTypeManager() != this.tm) {
            throw new IllegalStateException("Input parameters created by different type manager");
        }
        this.initialize();
        this.resetInputParams();
        this.inputParamDeclList = params;
    }

    public void setInputParams(Type[] params) {
        this.initialize();
        this.inputParamTypeNames = null;
        this.inputParamDeclList = new InputParameterDeclList(params, this.tm);
    }

    public void setQueryString(String s) {
        this.initialize();
        this.queryString = s;
    }

    public String getQueryString() {
        return this.queryString;
    }

    void setErrorCollector(ErrorCollector errColl) {
        if (!this.isCollectingErrors()) {
            throw new IllegalStateException("Context is not collecting errors");
        }
        this.ec = errColl;
    }

    void setProcessed() {
        this.processed = true;
    }

    void setParseTree(Query q) {
        this.parseTree = q;
    }

    public int getNofErrors() {
        if (!this.isCollectingErrors()) {
            throw new IllegalStateException("Context is not collecting errors");
        }
        if (!this.isProcessed()) {
            throw new IllegalStateException("Query string not processed yet");
        }
        return this.ec == null ? 0 : this.ec.getNofErrors();
    }

    public String getErrorMessages() {
        ErrorCollector ec = this.getErrorCollector();
        return ec == null ? "" : ec.getErrorMessages(this.queryString);
    }

    public ErrorCollector getErrorCollector() {
        if (!this.isCollectingErrors()) {
            throw new IllegalStateException("Context is not collecting errors");
        }
        if (!this.isProcessed()) {
            throw new IllegalStateException("Query string not processed yet");
        }
        return this.ec;
    }

    public InputParameterDeclList getInputParameters() {
        if (this.inputParamDeclList != null) {
            return this.inputParamDeclList;
        }
        if (this.inputParamTypeNames != null) {
            if (!this.isProcessed()) {
                throw new IllegalStateException("Input parameters not processed yet");
            }
            throw new IllegalStateException("Internal Error: Parser forgot to process input parameters");
        }
        return null;
    }

    public Query getParseTree() {
        return this.parseTree;
    }

    private void initialize() {
        this.ec = null;
        this.processed = false;
        this.parseTree = null;
    }
}

