/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql;

import com.sap.ejbql.EJBQLParserTokenTypes;
import com.sap.ejbql.Keyword;

class EJBQLKeywords
implements EJBQLParserTokenTypes {
    public static final int TOTAL_KEYWORDS = 37;
    public static final int MIN_HASH_VAL = 0;
    public static final int MAX_HASH_VAL = 36;
    public static final int MIN_CHAR_VAL = 65;
    public static final int MAX_CHAR_VAL = 89;
    public static final int MIN_WORD_LENG = 2;
    public static final int MAX_WORD_LENG = 9;
    private static final int MAX_TABLE_HEIGHT = 9;
    private static final int MAX_GRAPH_NODE_VAL = 185;
    private static final int[][] T1 = new int[][]{{38, 166, 95, 110, 155, 33, -1, -1, 162, -1, -1, 75, 135, 78, 119, -1, -1, -1, 127, 12, 18, -1, 124, -1, -1}, {105, 110, -1, -1, 111, 178, -1, 65, 82, -1, -1, -1, 158, 168, 155, -1, 108, 137, 15, -1, 86, 52, -1, -1, 61}, {-1, 111, 164, 127, 19, -1, 4, -1, -1, 13, 139, 64, 112, 46, 79, 42, -1, 137, 102, 127, 104, -1, -1, 184, -1}, {149, 37, 6, -1, 176, -1, 78, -1, -1, -1, -1, 35, 175, 29, -1, -1, -1, 154, 146, 46, -1, -1, 165, -1, -1}, {10, -1, 180, -1, 178, -1, -1, -1, 56, -1, -1, -1, -1, -1, 43, 184, -1, 107, -1, 5, -1, -1, -1, -1, 70}, {-1, -1, -1, -1, 184, -1, -1, 87, -1, -1, -1, -1, -1, 71, -1, -1, -1, 162, -1, 177, -1, -1, 100, -1, -1}, {-1, -1, 7, -1, -1, -1, -1, -1, 118, -1, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 88, -1, -1, -1, -1, -1, 130, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    private static final int[][] T2 = new int[][]{{184, 12, 80, 119, 154, 0, -1, -1, 84, -1, -1, 33, 10, 1, 65, -1, -1, -1, 87, 168, 4, -1, 51, -1, -1}, {100, 170, -1, -1, 80, 113, -1, 116, 33, -1, -1, -1, 153, 77, 150, -1, 39, 58, 163, -1, 155, 161, -1, -1, 2}, {-1, 101, 24, 81, 164, -1, 68, -1, -1, 173, 153, 147, 43, 51, 117, 168, -1, 114, 24, 157, 53, -1, -1, 25, -1}, {57, 11, 78, -1, 40, -1, 52, -1, -1, -1, -1, 146, 39, 107, -1, -1, -1, 3, 27, 30, -1, -1, 172, -1, -1}, {160, -1, 76, -1, 76, -1, -1, -1, 177, -1, -1, -1, -1, -1, 96, 46, -1, 98, -1, 165, -1, -1, -1, -1, 101}, {-1, -1, -1, -1, 64, -1, -1, 138, -1, -1, -1, -1, -1, 91, -1, -1, -1, 124, -1, 65, -1, -1, 98, -1, -1}, {-1, -1, 24, -1, -1, -1, -1, -1, 175, -1, -1, -1, -1, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 172, -1, -1, -1, -1, -1, 159, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 182, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    private static final int MAX_NODE_NUM = 59;
    private static final int[] node = new int[]{65, 8, 148, 157, 53, 162, 18, 27, 119, 29, 49, 102, 101, 51, 111, 138, 156, 165, 54, 145, 161, 177, 62, 32, 149, 74, 123, 180, 159, 175, 78, 79, 35, 34, 112, 178, 71, 95, 125, 48, 85, 14, 59, 134, 139, 1, 170, 40, 94, 43, 42, 0, 144, 116, 135, 47, 56, 140, 100};
    private static final int[] G = new int[]{0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 34, 10, 0, 8, 5, 0, 10, 0, 11, 0, 12, 8, 14, 0, 15, 2, 0, 17, 0, 18, 0, 19, 6, 0, 21, 0, 22, 23, 0, 24, 35, 27, 0, 26, 33, 32, 6, 30, 0, 31, 27, 0, 34, 0, 36};
    private static Keyword[] wordlist = new Keyword[37];

    EJBQLKeywords() {
    }

    private static void init() {
        EJBQLKeywords.wordlist[0] = new Keyword("ABS", 100);
        EJBQLKeywords.wordlist[1] = new Keyword("AND", 101);
        EJBQLKeywords.wordlist[2] = new Keyword("AS", 102);
        EJBQLKeywords.wordlist[3] = new Keyword("BETWEEN", 103);
        EJBQLKeywords.wordlist[4] = new Keyword("CONCAT", 104);
        EJBQLKeywords.wordlist[5] = new Keyword("DISTINCT", 105);
        EJBQLKeywords.wordlist[6] = new Keyword("EMPTY", 106);
        EJBQLKeywords.wordlist[7] = new Keyword("ESCAPE", 107);
        EJBQLKeywords.wordlist[8] = new Keyword("FALSE", 108);
        EJBQLKeywords.wordlist[9] = new Keyword("FROM", 109);
        EJBQLKeywords.wordlist[10] = new Keyword("IN", 110);
        EJBQLKeywords.wordlist[11] = new Keyword("IS", 111);
        EJBQLKeywords.wordlist[12] = new Keyword("LENGTH", 112);
        EJBQLKeywords.wordlist[13] = new Keyword("LIKE", 113);
        EJBQLKeywords.wordlist[14] = new Keyword("LOCATE", 114);
        EJBQLKeywords.wordlist[15] = new Keyword("MEMBER", 115);
        EJBQLKeywords.wordlist[16] = new Keyword("NOT", 116);
        EJBQLKeywords.wordlist[17] = new Keyword("NULL", 117);
        EJBQLKeywords.wordlist[18] = new Keyword("OBJECT", 118);
        EJBQLKeywords.wordlist[19] = new Keyword("OF", 119);
        EJBQLKeywords.wordlist[20] = new Keyword("OR", 120);
        EJBQLKeywords.wordlist[21] = new Keyword("SELECT", 121);
        EJBQLKeywords.wordlist[22] = new Keyword("SQRT", 122);
        EJBQLKeywords.wordlist[23] = new Keyword("SUBSTRING", 123);
        EJBQLKeywords.wordlist[24] = new Keyword("TRUE", 124);
        EJBQLKeywords.wordlist[25] = new Keyword("UNKNOWN", 125);
        EJBQLKeywords.wordlist[26] = new Keyword("WHERE", 126);
        EJBQLKeywords.wordlist[27] = new Keyword("ASC", 200);
        EJBQLKeywords.wordlist[28] = new Keyword("AVG", 201);
        EJBQLKeywords.wordlist[29] = new Keyword("BY", 202);
        EJBQLKeywords.wordlist[30] = new Keyword("COUNT", 203);
        EJBQLKeywords.wordlist[31] = new Keyword("DESC", 204);
        EJBQLKeywords.wordlist[32] = new Keyword("MAX", 205);
        EJBQLKeywords.wordlist[33] = new Keyword("MIN", 206);
        EJBQLKeywords.wordlist[34] = new Keyword("MOD", 207);
        EJBQLKeywords.wordlist[35] = new Keyword("ORDER", 208);
        EJBQLKeywords.wordlist[36] = new Keyword("SUM", 209);
    }

    private static int G_index(int n) {
        int i = 0;
        while (i < 59) {
            if (node[i] == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int hash(String key) {
        int leng = key.length();
        int f1 = 0;
        int f2 = 0;
        int n1 = -1;
        int n2 = -1;
        int i = 0;
        while (i < leng) {
            char c = key.charAt(i);
            if (c < 'A' || c > 'Y') {
                return -1;
            }
            int t1 = T1[i][key.charAt(i) - 65];
            int t2 = T2[i][key.charAt(i) - 65];
            if (t1 == -1 || t2 == -1) {
                return -1;
            }
            f1 += t1;
            f2 += t2;
            ++i;
        }
        n1 = EJBQLKeywords.G_index(f1 %= 185);
        n2 = EJBQLKeywords.G_index(f2 %= 185);
        if (n1 == -1 || n2 == -1) {
            return -1;
        }
        return (G[n1] + G[n2]) % 37;
    }

    public static Keyword in_word_set(String key) {
        Keyword rec;
        int ind;
        int len = key.length();
        if (len <= 9 && len >= 2 && (ind = EJBQLKeywords.hash(key)) <= 36 && ind >= 0 && (rec = wordlist[ind]).keyword().compareTo(key) == 0) {
            return rec;
        }
        return null;
    }

    public static void main(String[] args) {
        String key;
        int i = 0;
        while (i < wordlist.length) {
            key = wordlist[i].keyword();
            int ind = EJBQLKeywords.hash(key);
            System.out.println(key + " ===> wordlist[" + ind + "]:" + wordlist[ind].keyword());
            ++i;
        }
        key = new String("{~}");
        System.out.println(key + " ===> wordlist[" + EJBQLKeywords.hash(key) + "]");
    }

    public static int getTokenType(String key) {
        int len = key.length();
        if (len <= 9 && len >= 2) {
            int ind = EJBQLKeywords.hash(key);
            if (ind == -1) {
                return -1;
            }
            Keyword rec = wordlist[ind];
            String foundKey = wordlist[ind].keyword();
            if (foundKey.length() != len || foundKey.compareTo(key) != 0) {
                return -1;
            }
            return rec.type;
        }
        return -1;
    }

    static {
        EJBQLKeywords.init();
    }
}

