/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql;

import com.sap.ejbql.EJBQLParser;
import com.sap.ejbql.EJBQLParsingContext;
import com.sap.ejbql.SchemaManager;
import com.sap.ejbql.schema.SchemaManagerImpl;
import com.sap.ejbql.tree.Type;
import com.sap.ejbql.tree.TypeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

class EJBQLChecker {
    public static BufferedReader in;
    public static PrintStream out;
    public static SchemaManagerImpl sm;
    public static TypeManager tm;
    public static EJBQLParsingContext ctx;
    public static EJBQLParser parser;

    EJBQLChecker() {
    }

    public static void main(String[] args) throws IOException {
        sm = new SchemaManagerImpl();
        sm.buildSchema(args);
        tm = new TypeManager((SchemaManager)sm);
        ctx = new EJBQLParsingContext(tm);
        parser = new EJBQLParser();
        in = new BufferedReader(new InputStreamReader(System.in));
        out = System.out;
        if (args.length == 0) {
            EJBQLChecker.processMain('n');
        } else {
            EJBQLChecker.processMain('q');
        }
    }

    private static void processMain(char startCmd) throws IOException {
        int cmd = startCmd;
        while (true) {
            out.println("\n*** Main Menue ***");
            out.println("\t[n]ew schema,");
            out.println("\t[e]xtend schema,");
            out.println("\t[q]uery schema,");
            out.println("\t[p]rint schema,");
            out.println("\t[r]eturn,");
            out.print("Command [[" + (char)cmd + "]]: ");
            String line = in.readLine();
            if (line == null || line.length() == 0) {
                line = "" + (char)cmd;
            }
            int newCmd = line.toLowerCase().charAt(0);
            switch (newCmd) {
                case 110: {
                    EJBQLChecker.extendSchema(true);
                    newCmd = 112;
                    break;
                }
                case 101: {
                    EJBQLChecker.extendSchema(false);
                    newCmd = 112;
                    break;
                }
                case 113: {
                    EJBQLChecker.querySchema();
                    break;
                }
                case 112: {
                    sm.printSchema();
                    newCmd = 113;
                    break;
                }
                case 114: {
                    return;
                }
                default: {
                    out.println("Unknown command");
                    newCmd = cmd;
                }
            }
            cmd = newCmd;
        }
    }

    private static void extendSchema(boolean reset) throws IOException {
        out.println("\nGive name of xml file, class file or jar (multiple files separated by space)");
        out.print("File(s): ");
        String line = in.readLine();
        StringTokenizer st = new StringTokenizer(line);
        String[] files = new String[st.countTokens()];
        int i = 0;
        while (i < files.length) {
            files[i] = st.nextToken();
            ++i;
        }
        if (reset) {
            sm.buildSchema(files);
            tm = new TypeManager((SchemaManager)sm);
        } else {
            sm.extendSchema(files);
        }
    }

    private static void querySchema() {
        int cmd = 105;
        while (true) {
            out.println("\n*** Query Schema ***");
            out.println("\t[i]nput parameter definition,");
            out.println("\t[l]ist input parameters,");
            out.println("\t[q]uery string definition,");
            out.println("\t[s]how query string,");
            out.println("\t[c]ompile,");
            out.println("\t[r]eturn,");
            out.print("Command [[" + (char)cmd + "]]: ");
            try {
                String line = in.readLine();
                if (line == null || line.length() == 0) {
                    line = "" + (char)cmd;
                }
                int newCmd = line.toLowerCase().charAt(0);
                switch (newCmd) {
                    case 105: {
                        EJBQLChecker.defineInputParams();
                        newCmd = 113;
                        break;
                    }
                    case 108: {
                        EJBQLChecker.listInputParams();
                        newCmd = 113;
                        break;
                    }
                    case 113: {
                        EJBQLChecker.defineQueryString();
                        newCmd = 99;
                        break;
                    }
                    case 115: {
                        EJBQLChecker.showQueryString();
                        newCmd = 99;
                        break;
                    }
                    case 99: {
                        EJBQLChecker.compile();
                        newCmd = 113;
                        break;
                    }
                    case 114: {
                        return;
                    }
                    default: {
                        out.println("Unknown command");
                        newCmd = cmd;
                    }
                }
                cmd = newCmd;
            }
            catch (IOException e) {
                System.err.println("Cannot read input");
                return;
            }
        }
    }

    private static void defineInputParams() {
        int p_no = 1;
        out.println("\nGive the type for each input param (empty line to return)");
        try {
            ArrayList<Type> params = new ArrayList<Type>();
            while (true) {
                out.print(p_no + ". parameter: ");
                String line = in.readLine();
                if (line == null || line.length() == 0) break;
                Type type = EJBQLChecker.getType(line);
                if (type == null) {
                    out.println("Type " + line + " doesn't exist. Retry ...");
                    continue;
                }
                params.add(type);
                ++p_no;
            }
            Type[] inp = new Type[params.size()];
            params.toArray(inp);
            ctx.setInputParams(inp);
        }
        catch (IOException e) {
            System.err.println("Cannot read input");
        }
    }

    private static void listInputParams() {
        Type[] params = ctx.getInputParameters().getInputParameterTypes();
        out.println("");
        if (params == null || params.length == 0) {
            out.println("No input parameters defined");
        } else {
            int i = 0;
            while (i < params.length) {
                out.println(i + 1 + ". parameter: " + params[i]);
                ++i;
            }
        }
    }

    private static void defineQueryString() throws IOException {
        String line;
        String queryString = "";
        out.println("\nGive the query string (empty line to return)");
        while ((line = in.readLine()) != null && line.length() != 0) {
            queryString = queryString + line + "\n";
        }
        ctx.setQueryString(queryString);
    }

    private static void showQueryString() {
        String query = ctx.getQueryString();
        out.println("");
        if (query == null || query.length() == 0) {
            out.println("No query string defined");
        } else {
            out.println(query);
        }
    }

    private static void compile() {
        parser.parse(ctx);
        if (ctx.getNofErrors() == 0) {
            out.println("*** no errors found ***");
        } else {
            out.println(ctx.getErrorMessages());
        }
    }

    private static Type getType(String name) {
        if (tm.hasType(name)) {
            return tm.getType(name);
        }
        return null;
    }
}

