/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql;

import com.sap.ejbql.EJBQLParser;
import com.sap.ejbql.EJBQLParsingContext;
import com.sap.ejbql.SchemaManager;
import com.sap.ejbql.schema.SchemaManagerImpl;
import com.sap.ejbql.tree.TypeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;

class BatchChecker {
    public static BufferedReader in;
    public static PrintStream out;
    public static SchemaManagerImpl sm;
    public static TypeManager tm;
    public static EJBQLParsingContext ctx;
    public static EJBQLParser parser;
    public static int cnt;

    BatchChecker() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: java com.sap.ejbql.BatchChecker files ...\n\twhere files are any valid jar, xml or class files\n\tcontaining a schema description (usually an ejb group,\n\ta deployment descriptor and associated class files).\nQuery statements are read from stdin, where multiple statements are\nseparated by an empty line. Input parameters can be optionally\nspecified by preceding the statement with a list of types in '[]',\nas in:\n\t[ int, java.lang.String ]\n\tselect object(o) from .....\n");
        }
        sm = new SchemaManagerImpl();
        sm.buildSchema(args);
        tm = new TypeManager((SchemaManager)sm);
        ctx = new EJBQLParsingContext(tm);
        parser = new EJBQLParser();
        in = new BufferedReader(new InputStreamReader(System.in));
        out = System.out;
        StringBuffer buf = new StringBuffer(1024);
        while (true) {
            String line;
            if ((line = in.readLine()) == null) break;
            if (line.length() == 0) {
                BatchChecker.compile(buf.toString());
                buf = new StringBuffer(1024);
                continue;
            }
            buf.append(line);
            buf.append('\n');
        }
        BatchChecker.compile(buf.toString());
    }

    private static void compile(String queryString) {
        String params = null;
        if (queryString.length() == 0) {
            return;
        }
        if (queryString.startsWith("[")) {
            int idx = queryString.indexOf(93);
            params = queryString.substring(1, idx);
            if ((queryString = queryString.substring(idx + 1)).startsWith("\n")) {
                queryString = queryString.substring(1);
            }
            StringTokenizer st = new StringTokenizer(params, "\t ,;");
            String[] par = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                par[i] = st.nextToken();
                ++i;
            }
            ctx.setInputParams(par);
        } else {
            ctx.resetInputParams();
        }
        out.println("================================================================================");
        if (params != null) {
            out.println("Params: [" + params + "]");
        }
        out.println("Query #" + ++cnt + ": " + queryString);
        ctx.setQueryString(queryString);
        try {
            parser.parse(ctx);
        }
        catch (Exception e) {
            out.println(e.getMessage());
            e.printStackTrace();
        }
        out.println(ctx.getErrorMessages());
        int errors = ctx.getNofErrors();
        if (errors != 0) {
            out.println("" + errors + " error(s) detected");
        } else {
            out.println("*** is ok ***");
        }
    }

    static {
        cnt = 0;
    }
}

