/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.zones;

import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.httpserver.Zone;
import com.sap.engine.services.httpserver.ZoneManagementInterface;
import com.sap.engine.services.httpserver.exceptions.HttpIllegalArgumentException;
import com.sap.engine.services.httpserver.server.HttpProviderImpl;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.zones.ConfigurationListener;
import com.sap.engine.services.httpserver.server.zones.ConfigurationReader;
import com.sap.engine.services.httpserver.server.zones.ConfigurationWriter;
import com.sap.engine.services.httpserver.server.zones.ZoneImpl;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class ZoneManagementImpl
extends PortableRemoteObject
implements ZoneManagementInterface {
    private ConcurrentHashMapObjectObject zones;
    private ConfigurationReader configurationReader;
    private ConfigurationWriter configurationWriter;
    private Log log;
    private HttpProviderImpl httpProvider;

    /*
     * Loose catch block
     */
    public ZoneManagementImpl(ConfigurationHandlerFactory factory, Log log, HttpProviderImpl httpProvider) throws RemoteException {
        block14: {
            this.zones = new ConcurrentHashMapObjectObject();
            this.configurationReader = null;
            this.configurationWriter = null;
            this.log = null;
            this.httpProvider = null;
            this.log = log;
            this.httpProvider = httpProvider;
            this.configurationReader = new ConfigurationReader(this, factory, log);
            this.configurationWriter = new ConfigurationWriter(factory, log);
            int count = 0;
            while ((long)count < 100L) {
                try {
                    this.configurationReader.readAll();
                    break;
                }
                catch (InconsistentReadException e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                    }
                    if ((long)count == 99L) {
                        log.logError("Cannot read and initialize http zones. Any http zones configurations will be ignored. Probably a cluster lock for Http Provider service cannot be obtained.", e, null);
                    }
                    ++count;
                }
            }
            ConfigurationHandler handler = null;
            handler = factory.getConfigurationHandler();
            handler.addConfigurationChangedListener((ConfigurationChangedListener)new ConfigurationListener(this, this.configurationReader), "HttpZones");
            handler.commit();
            Object var8_9 = null;
            try {
                handler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                log.logError("Cannot close all configuration handlers after registering a configuration listener for configuration [HttpZones].", e2, null);
            }
            break block14;
            {
                catch (Exception e) {
                    log.logError("Cannot register a configuration listener for configuration [HttpZones].", e, null);
                    Object var8_10 = null;
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        log.logError("Cannot close all configuration handlers after registering a configuration listener for configuration [HttpZones].", e2, null);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    handler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    log.logError("Cannot close all configuration handlers after registering a configuration listener for configuration [HttpZones].", e2, null);
                }
                throw throwable;
            }
        }
    }

    public synchronized Zone[] getAllZones() {
        Object[] zonesObj = this.zones.toArray();
        if (zonesObj == null) {
            return null;
        }
        Zone[] res = new Zone[zonesObj.length];
        System.arraycopy(zonesObj, 0, res, 0, res.length);
        return res;
    }

    public synchronized Zone getZone(String zoneName) {
        return (Zone)this.zones.get((Object)zoneName);
    }

    public synchronized void registerZone(String zoneName) throws IllegalArgumentException, ConfigurationException {
        try {
            this.configurationReader.readAll();
        }
        catch (InconsistentReadException e) {
            Log.logWarning("The cached zones were not updated!", e, null);
        }
        if (this.zones.containsKey((Object)zoneName)) {
            throw new HttpIllegalArgumentException("http_0069", new Object[]{zoneName});
        }
        try {
            int count = 0;
            while ((long)count < 100L) {
                try {
                    this.configurationWriter.createZone(zoneName);
                    break;
                }
                catch (InconsistentReadException e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                    }
                    if ((long)count == 99L) {
                        throw e;
                    }
                    ++count;
                }
            }
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot create zone [" + zoneName + "]. Probably a configuration access problem has occurred", e, null);
            throw e;
        }
        this.notifyZoneChanged();
        this.newZoneRegistered(zoneName);
    }

    public synchronized void unregisterZone(String zoneName) throws ConfigurationException {
        try {
            int count = 0;
            while ((long)count < 100L) {
                try {
                    this.configurationWriter.deleteZone(zoneName);
                    break;
                }
                catch (InconsistentReadException e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                    }
                    if ((long)count == 99L) {
                        throw e;
                    }
                    ++count;
                }
            }
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot delete http zone [" + zoneName + "].  Probably a configuration access problem has occurred.", e, null);
            throw e;
        }
        this.notifyZoneChanged();
        this.zoneUnregistered(zoneName);
    }

    public boolean isExactAlias(String alias) {
        if (alias == null) {
            return false;
        }
        Object[] zonesObj = this.zones.toArray();
        if (zonesObj == null) {
            return false;
        }
        int i = 0;
        while (zonesObj != null && i < zonesObj.length) {
            String[] exactAliasesOfZone = ((ZoneImpl)zonesObj[i]).getExactAliases();
            int j = 0;
            while (exactAliasesOfZone != null && j < exactAliasesOfZone.length) {
                if (alias.equals(exactAliasesOfZone[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected synchronized ZoneImpl newZoneRegistered(String zoneName) {
        ZoneImpl newZone = null;
        try {
            newZone = new ZoneImpl(zoneName, this.configurationWriter, this.log, this);
        }
        catch (RemoteException e) {
            this.log.logError("Cannot create http zone [" + zoneName + "]. Probably a configuration access problem has occurred.", e, null);
            return null;
        }
        this.zones.put((Object)zoneName, (Object)newZone);
        return newZone;
    }

    protected synchronized void zoneUnregistered(String zoneName) {
        this.zones.remove((Object)zoneName);
    }

    protected synchronized void allZonesUnregistered() {
        this.zones.clear();
    }

    protected void notifyZoneChanged() {
        this.httpProvider.zonesChanged();
    }

    protected int[] getAllServersForGroups(int[] groups) {
        ArrayInt servers = new ArrayInt();
        int i = 0;
        while (i < groups.length) {
            servers.addAll(this.httpProvider.getServers(groups[i]));
            ++i;
        }
        return servers.toArray();
    }

    protected int getGroupId(int serverId) {
        return this.httpProvider.getGroup(serverId);
    }
}

