/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.zones;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.Zone;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.zones.ConfigurationWriter;
import com.sap.engine.services.httpserver.server.zones.ZoneManagementImpl;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class ZoneImpl
extends PortableRemoteObject
implements Zone {
    private ZoneManagementImpl zoneManagement = null;
    private ConfigurationWriter configurationWriter = null;
    private Log log = null;
    private String zoneName = null;
    private ArrayInt instances = new ArrayInt();
    private ArrayObject aliases = new ArrayObject();
    private ArrayObject exactAliases = new ArrayObject();

    public ZoneImpl(String zoneName, ConfigurationWriter configurationWriter, Log log, ZoneManagementImpl zoneManagement) throws RemoteException {
        this.zoneName = zoneName;
        this.configurationWriter = configurationWriter;
        this.log = log;
        this.zoneManagement = zoneManagement;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public synchronized int[] getInstances() {
        return this.instances.toArray();
    }

    public synchronized int[] getServers() {
        return this.zoneManagement.getAllServersForGroups(this.instances.toArray());
    }

    public synchronized String[] getAliases() {
        Object[] aliasesArray = this.aliases.toArray();
        if (aliasesArray == null) {
            return null;
        }
        String[] res = new String[aliasesArray.length];
        System.arraycopy(aliasesArray, 0, res, 0, res.length);
        return res;
    }

    public synchronized String[] getExactAliases() {
        Object[] aliasesArray = this.exactAliases.toArray();
        if (aliasesArray == null) {
            return null;
        }
        String[] res = new String[aliasesArray.length];
        System.arraycopy(aliasesArray, 0, res, 0, res.length);
        return res;
    }

    public synchronized void addServer(int serverId) throws ConfigurationException {
        this.addInstance(this.zoneManagement.getGroupId(serverId));
    }

    public synchronized void addInstance(int groupId) throws ConfigurationException {
        if (!this.instances.contains(groupId)) {
            this.instances.add(groupId);
            try {
                int count = 0;
                while ((long)count < 100L) {
                    try {
                        this.configurationWriter.updateInstances(this.getZoneName(), this.getInstances());
                        break;
                    }
                    catch (InconsistentReadException e) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                        }
                        if ((long)count == 99L) {
                            throw e;
                        }
                        ++count;
                    }
                }
            }
            catch (ConfigurationException e) {
                this.instances.removeElement(groupId);
                this.log.logError("Cannot add an instance [" + groupId + "] to http zone [" + this.getZoneName() + "]. Probably a configuration access problem has occurred.", e, null);
                throw e;
            }
            this.zoneManagement.notifyZoneChanged();
        }
    }

    protected synchronized void instanceAdded(int groupId) {
        if (!this.instances.contains(groupId)) {
            this.instances.add(groupId);
        }
    }

    public synchronized void removeServer(int serverId) throws ConfigurationException {
        this.removeInstance(this.zoneManagement.getGroupId(serverId));
    }

    public synchronized void removeInstance(int groupId) throws ConfigurationException {
        this.instances.remove(groupId);
        try {
            int count = 0;
            while ((long)count < 100L) {
                try {
                    this.configurationWriter.updateInstances(this.getZoneName(), this.getInstances());
                    break;
                }
                catch (InconsistentReadException e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                    }
                    if ((long)count == 99L) {
                        throw e;
                    }
                    ++count;
                }
            }
        }
        catch (ConfigurationException e) {
            this.instances.removeElement(groupId);
            this.log.logError("Cannot remove an instance [" + groupId + "] from http zone [" + this.getZoneName() + "]. Probably a configuration access problem has occurred.", e, null);
            throw e;
        }
        this.zoneManagement.notifyZoneChanged();
    }

    public synchronized void instanceRemoved(int groupId) {
        this.instances.remove(groupId);
    }

    public synchronized void addServers(int[] serverIds) throws ConfigurationException {
        int i = 0;
        while (serverIds != null && i < serverIds.length) {
            this.addServer(serverIds[i]);
            ++i;
        }
    }

    public synchronized void addInstances(int[] groupIds) throws ConfigurationException {
        int i = 0;
        while (groupIds != null && i < groupIds.length) {
            this.addInstance(groupIds[i]);
            ++i;
        }
    }

    public synchronized void instancesAdded(int[] groupIds) throws ConfigurationException {
        int i = 0;
        while (groupIds != null && i < groupIds.length) {
            this.instanceAdded(groupIds[i]);
            ++i;
        }
    }

    public synchronized void clearAllServers() throws ConfigurationException {
        this.clearAllInstances();
    }

    public synchronized void clearAllInstances() throws ConfigurationException {
        this.instances.clear();
        try {
            int count = 0;
            while ((long)count < 100L) {
                try {
                    this.configurationWriter.updateInstances(this.getZoneName(), this.getInstances());
                    break;
                }
                catch (InconsistentReadException e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                    }
                    if ((long)count == 99L) {
                        throw e;
                    }
                    ++count;
                }
            }
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot remove all instances from http zone [" + this.getZoneName() + "]. Probably a configuration access problem has occurred.", e, null);
            throw e;
        }
        this.zoneManagement.notifyZoneChanged();
    }

    public synchronized void instancesCleared() throws ConfigurationException {
        this.instances.clear();
    }

    public synchronized void addAlias(String alias) throws ConfigurationException {
        if (!this.aliases.contains((Object)alias)) {
            this.aliases.add((Object)alias);
            try {
                this.configurationWriter.updateAliases(this.getZoneName(), this.getAliases());
            }
            catch (ConfigurationException e) {
                this.log.logError("Cannot add http alias [" + alias + "] to http zone [" + this.getZoneName() + "]. Probably a configuration access problem has occurred.", e, null);
                throw e;
            }
            this.zoneManagement.notifyZoneChanged();
        }
    }

    public synchronized void addExactAlias(String alias) throws ConfigurationException {
        if (!this.exactAliases.contains((Object)alias)) {
            this.exactAliases.add((Object)alias);
            try {
                this.configurationWriter.updateExactAliases(this.getZoneName(), this.getAliases());
            }
            catch (ConfigurationException e) {
                this.log.logError("Cannot add http alias [" + alias + "] to http zone [" + this.getZoneName() + "]. Probably a configuration access problem has occurred.", e, null);
                throw e;
            }
            this.zoneManagement.notifyZoneChanged();
        }
    }

    protected synchronized void aliasAdded(String alias) {
        if (!this.aliases.contains((Object)alias)) {
            this.aliases.add((Object)alias);
        }
    }

    protected synchronized void exactAliasAdded(String alias) {
        if (!this.exactAliases.contains((Object)alias)) {
            this.exactAliases.add((Object)alias);
        }
    }

    public synchronized void removeAlias(String alias) throws ConfigurationException {
        this.aliases.remove((Object)alias);
        try {
            this.configurationWriter.updateAliases(this.getZoneName(), this.getAliases());
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot remove http alias [" + alias + "] from http zone [" + this.getZoneName() + "] Probably a configuration access problem has occurred.", e, null);
            throw e;
        }
        this.zoneManagement.notifyZoneChanged();
    }

    public synchronized void removeExactAlias(String alias) throws ConfigurationException {
        this.exactAliases.remove((Object)alias);
        try {
            this.configurationWriter.updateExactAliases(this.getZoneName(), this.getAliases());
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot remove http alias [" + alias + "] from http zone [" + this.getZoneName() + "] Probably a configuration access problem has occurred.", e, null);
            throw e;
        }
        this.zoneManagement.notifyZoneChanged();
    }

    protected synchronized void aliasRemoved(String alias) {
        this.aliases.remove((Object)alias);
    }

    public synchronized void addAliases(String[] aliases) throws ConfigurationException {
        int i = 0;
        while (aliases != null && i < aliases.length) {
            this.addAlias(aliases[i]);
            ++i;
        }
    }

    public synchronized void addExactAliases(String[] aliases) throws ConfigurationException {
        int i = 0;
        while (aliases != null && i < aliases.length) {
            this.addExactAlias(aliases[i]);
            ++i;
        }
    }

    public synchronized void aliasesAdded(String[] aliases) throws ConfigurationException {
        int i = 0;
        while (aliases != null && i < aliases.length) {
            this.aliasAdded(aliases[i]);
            ++i;
        }
    }

    public synchronized void exactAliasesAdded(String[] aliases) throws ConfigurationException {
        int i = 0;
        while (aliases != null && i < aliases.length) {
            this.exactAliasAdded(aliases[i]);
            ++i;
        }
    }

    public synchronized void clearAllAliases() throws ConfigurationException {
        this.aliases.clear();
        this.exactAliases.clear();
        try {
            this.configurationWriter.updateAliases(this.getZoneName(), this.getAliases());
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot remove all http aliases from http zone [" + this.getZoneName() + "]. Probably a configuration access problem has occurred.", e, null);
            throw e;
        }
        try {
            this.configurationWriter.updateExactAliases(this.getZoneName(), this.getAliases());
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot remove all http aliases from http zone [" + this.getZoneName() + "]. Probably a configuration access problem has occurred.", e, null);
            throw e;
        }
        this.zoneManagement.notifyZoneChanged();
    }

    public synchronized void aliasesCleared() throws ConfigurationException {
        this.aliases.clear();
    }

    public synchronized void exactAliasesCleared() throws ConfigurationException {
        this.exactAliases.clear();
    }
}

