/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.zones;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.services.httpserver.server.HttpLock;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Log;

public class ConfigurationWriter {
    private ConfigurationHandlerFactory factory = null;
    private Log log = null;

    public ConfigurationWriter(ConfigurationHandlerFactory factory, Log log) {
        this.factory = factory;
        this.log = log;
    }

    public synchronized void createZone(String zoneName) throws ConfigurationException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing zones settings.", e, null);
        }
        try {
            Configuration hostConfiguration = null;
            try {
                hostConfiguration = handler.openConfiguration("HttpZones", 1);
            }
            catch (NameNotFoundException e) {
                hostConfiguration = handler.createSubConfiguration("HttpZones");
                hostConfiguration.setCacheMode(18);
            }
            try {
                hostConfiguration = hostConfiguration.getSubConfiguration(zoneName);
            }
            catch (NameNotFoundException ex) {
                hostConfiguration = hostConfiguration.createSubConfiguration(zoneName);
                hostConfiguration.setCacheMode(18);
            }
            handler.commit();
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                handler.closeAllConfigurations();
                Object var9_12 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                try {
                    httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
                }
                catch (Exception e) {
                    Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
                }
                throw throwable2;
            }
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
            }
            throw throwable;
        }
        try {
            httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
        }
    }

    public synchronized void deleteZone(String zoneName) throws ConfigurationException {
        Object v3;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing zones settings.", e, null);
        }
        try {
            Configuration hostConfiguration = null;
            try {
                hostConfiguration = handler.openConfiguration("HttpZones", 1);
            }
            catch (NameNotFoundException e) {
                Object v0;
                Object var7_8 = null;
                try {
                    handler.closeAllConfigurations();
                    v0 = null;
                }
                catch (Throwable throwable) {
                    v0 = null;
                }
                Object var9_16 = v0;
                try {
                    httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
                }
                catch (Exception e2) {
                    Log.logWarning("Cannot close cluster lock for zones settings.", e2, null);
                }
                return;
            }
            try {
                hostConfiguration = hostConfiguration.getSubConfiguration(zoneName);
            }
            catch (NameNotFoundException ex) {
                Object v1;
                Object var7_9 = null;
                try {
                    handler.closeAllConfigurations();
                    v1 = null;
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                Object var9_17 = v1;
                try {
                    httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
                }
                catch (Exception e2) {
                    Log.logWarning("Cannot close cluster lock for zones settings.", e2, null);
                }
                return;
            }
            hostConfiguration.deleteConfiguration();
            handler.commit();
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object v2;
            Object var7_11 = null;
            try {
                handler.closeAllConfigurations();
                v2 = null;
            }
            catch (Throwable throwable2) {
                v2 = null;
            }
            Object var9_19 = v2;
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e2) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e2, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            v3 = null;
        }
        catch (Throwable throwable) {
            v3 = null;
        }
        Object var9_18 = v3;
        try {
            httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e2) {
            Log.logWarning("Cannot close cluster lock for zones settings.", e2, null);
        }
    }

    public synchronized void updateInstances(String zoneName, int[] groupIds) throws ConfigurationException {
        Object v1;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing zones settings.", e, null);
        }
        try {
            Configuration hostConfiguration = null;
            try {
                hostConfiguration = handler.openConfiguration("HttpZones", 1);
            }
            catch (NameNotFoundException e) {
                hostConfiguration = handler.createSubConfiguration("HttpZones");
                hostConfiguration.setCacheMode(18);
            }
            try {
                hostConfiguration = hostConfiguration.getSubConfiguration(zoneName);
            }
            catch (NameNotFoundException ex) {
                hostConfiguration = hostConfiguration.createSubConfiguration(zoneName);
                hostConfiguration.setCacheMode(18);
            }
            if (groupIds != null) {
                hostConfiguration.modifyConfigEntry("instances", (Object)this.toString(groupIds), true);
            } else {
                hostConfiguration.deleteConfigEntry("instances");
            }
            handler.commit();
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var8_10 = null;
            try {
                handler.closeAllConfigurations();
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var10_14 = v0;
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var10_13 = v1;
        try {
            httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
        }
    }

    public synchronized void updateAliases(String zoneName, String[] aliases) throws ConfigurationException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing zones settings.", e, null);
        }
        try {
            Configuration hostConfiguration = null;
            try {
                hostConfiguration = handler.openConfiguration("HttpZones", 1);
            }
            catch (NameNotFoundException e) {
                hostConfiguration = handler.createSubConfiguration("HttpZones");
                hostConfiguration.setCacheMode(18);
            }
            try {
                hostConfiguration = hostConfiguration.getSubConfiguration(zoneName);
            }
            catch (NameNotFoundException ex) {
                hostConfiguration = hostConfiguration.createSubConfiguration(zoneName);
                hostConfiguration.setCacheMode(18);
            }
            if (aliases != null) {
                hostConfiguration.modifyConfigEntry("aliases", (Object)this.toString(aliases), true);
            } else {
                hostConfiguration.deleteConfigEntry("aliases");
            }
            handler.commit();
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                handler.closeAllConfigurations();
                Object var10_13 = null;
            }
            catch (Throwable throwable2) {
                Object var10_14 = null;
                try {
                    httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
                }
                catch (Exception e) {
                    Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
                }
                throw throwable2;
            }
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
            }
            throw throwable;
        }
        try {
            httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
        }
    }

    public synchronized void updateExactAliases(String zoneName, String[] aliases) throws ConfigurationException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing zones settings.", e, null);
        }
        try {
            Configuration hostConfiguration = null;
            try {
                hostConfiguration = handler.openConfiguration("HttpZones", 1);
            }
            catch (NameNotFoundException e) {
                hostConfiguration = handler.createSubConfiguration("HttpZones");
                hostConfiguration.setCacheMode(18);
            }
            try {
                hostConfiguration = hostConfiguration.getSubConfiguration(zoneName);
            }
            catch (NameNotFoundException ex) {
                hostConfiguration = hostConfiguration.createSubConfiguration(zoneName);
                hostConfiguration.setCacheMode(18);
            }
            if (aliases != null) {
                hostConfiguration.modifyConfigEntry("exact-aliases", (Object)this.toString(aliases), true);
            } else {
                hostConfiguration.deleteConfigEntry("exact-aliases");
            }
            handler.commit();
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                handler.closeAllConfigurations();
                Object var10_13 = null;
            }
            catch (Throwable throwable2) {
                Object var10_14 = null;
                try {
                    httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
                }
                catch (Exception e) {
                    Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
                }
                throw throwable2;
            }
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
            }
            throw throwable;
        }
        try {
            httpLock.leaveLockArea(HttpLock.ZONES_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for zones settings.", e, null);
        }
    }

    private String toString(int[] groupIds) {
        String res = "";
        int i = 0;
        while (groupIds != null && i < groupIds.length) {
            res = res + groupIds[i] + ", ";
            ++i;
        }
        if (res.length() != 0) {
            res = res.substring(0, res.length() - 2);
        }
        return res;
    }

    private String toString(String[] aliases) {
        String res = "";
        int i = 0;
        while (aliases != null && i < aliases.length) {
            res = res + aliases[i] + ", ";
            ++i;
        }
        if (res.length() != 0) {
            res = res.substring(0, res.length() - 2);
        }
        return res;
    }
}

