/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.zones;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.zones.ZoneImpl;
import com.sap.engine.services.httpserver.server.zones.ZoneManagementImpl;
import java.util.StringTokenizer;

public class ConfigurationReader {
    private ZoneManagementImpl zoneManagement = null;
    private ConfigurationHandlerFactory factory = null;
    private Log log = null;

    public ConfigurationReader(ZoneManagementImpl zoneManagement, ConfigurationHandlerFactory factory, Log log) {
        this.zoneManagement = zoneManagement;
        this.log = log;
        this.factory = factory;
    }

    public synchronized void readAll() throws InconsistentReadException {
        ConfigurationHandler handler = null;
        try {
            handler = this.factory.getConfigurationHandler();
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot access configuration. Http zones will not be initialized.", e, null);
        }
        Configuration hostConfig = null;
        try {
            hostConfig = handler.openConfiguration("HttpZones", 0);
        }
        catch (NameNotFoundException e) {
            return;
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot open configuration [HttpZones]. Http zones will not be initialized.", e, null);
        }
        try {
            this.setZones(hostConfig);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                handler.closeAllConfigurations();
            }
            catch (ConfigurationException e) {
                this.log.logError("Cannot close configurations used for reading http zones.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot close configurations used for reading http zones.", e, null);
        }
    }

    public void zoneUpdated(String zoneName) {
        try {
            this.initZone(zoneName);
        }
        catch (ConfigurationException e) {
            this.log.logError("Cannot initialize or update settings for http zone [" + zoneName + "]. Probably a configuration access problem has occurred.", e, null);
        }
    }

    /*
     * Loose catch block
     */
    private void setZones(Configuration configuration) throws InconsistentReadException {
        String[] zoneNames;
        block14: {
            zoneNames = null;
            zoneNames = configuration.getAllSubConfigurationNames();
            Object var6_3 = null;
            try {
                configuration.close();
            }
            catch (ConfigurationException e2) {
                this.log.logError("Cannot close configurations used for reading http zones.", e2, null);
            }
            break block14;
            {
                catch (InconsistentReadException e) {
                    throw e;
                }
                catch (ConfigurationException e) {
                    this.log.logError("Cannot read and initialize http zones. All zones settings will be ignored. Probably a configuration access problem has occurred.", e, null);
                    Object var6_4 = null;
                    try {
                        configuration.close();
                    }
                    catch (ConfigurationException e2) {
                        this.log.logError("Cannot close configurations used for reading http zones.", e2, null);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    configuration.close();
                }
                catch (ConfigurationException e2) {
                    this.log.logError("Cannot close configurations used for reading http zones.", e2, null);
                }
                throw throwable;
            }
        }
        int i = 0;
        while (zoneNames != null && i < zoneNames.length) {
            try {
                this.initZone(zoneNames[i]);
            }
            catch (InconsistentReadException e) {
                throw e;
            }
            catch (ConfigurationException e) {
                this.log.logError("Cannot initialize http zone [" + zoneNames[i] + "]. All settings for this zone will be ignored. Probably a configuration access problem has occurred.", e, null);
            }
            ++i;
        }
    }

    private void initZone(String zoneName) throws ConfigurationException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration hostConfig = null;
        try {
            hostConfig = handler.openConfiguration("HttpZones/" + zoneName, 0);
        }
        catch (NameNotFoundException e) {
            this.zoneManagement.zoneUnregistered(zoneName);
            return;
        }
        try {
            ZoneImpl zone = (ZoneImpl)this.zoneManagement.getZone(zoneName);
            if (zone == null) {
                zone = this.zoneManagement.newZoneRegistered(zoneName);
            }
            zone.instancesCleared();
            zone.aliasesCleared();
            int[] groups = null;
            try {
                String instances = (String)hostConfig.getConfigEntry("instances");
                groups = this.fromStringInt(instances);
                zone.instancesAdded(groups);
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            String[] aliases = null;
            try {
                String alias = (String)hostConfig.getConfigEntry("aliases");
                aliases = this.fromStringString(alias);
                zone.aliasesAdded(aliases);
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            String[] exactAliases = null;
            try {
                String exactAlias = (String)hostConfig.getConfigEntry("exact-aliases");
                exactAliases = this.fromStringString(exactAlias);
                zone.exactAliasesAdded(exactAliases);
            }
            catch (NameNotFoundException e) {
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            handler.closeAllConfigurations();
            throw throwable;
        }
        handler.closeAllConfigurations();
    }

    private int[] fromStringInt(String res) {
        if (res == null) {
            return null;
        }
        int[] groupIds = new int[]{};
        StringTokenizer tokenizer = new StringTokenizer(res, ",");
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken().trim();
            int nextInt = -1;
            try {
                nextInt = new Integer(next);
            }
            catch (NumberFormatException e) {
                this.log.logError("Cannot register an instance to an http zone. Illegal group id [" + next + "] is specified.", e, null);
                continue;
            }
            int[] tmp = new int[groupIds.length + 1];
            System.arraycopy(groupIds, 0, tmp, 0, groupIds.length);
            tmp[groupIds.length] = nextInt;
            groupIds = tmp;
        }
        return groupIds;
    }

    private String[] fromStringString(String res) {
        if (res == null) {
            return null;
        }
        String[] aliases = new String[]{};
        StringTokenizer tokenizer = new StringTokenizer(res, ",");
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken().trim();
            String[] tmp = new String[aliases.length + 1];
            System.arraycopy(aliases, 0, tmp, 0, aliases.length);
            tmp[aliases.length] = next;
            aliases = tmp;
        }
        return aliases;
    }
}

