/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.zones;

import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.zones.ConfigurationReader;
import com.sap.engine.services.httpserver.server.zones.ZoneManagementImpl;

public class ConfigurationListener
implements ConfigurationChangedListener {
    private ZoneManagementImpl zoneManagement = null;
    private ConfigurationReader configurationReader = null;

    public ConfigurationListener(ZoneManagementImpl zoneManagement, ConfigurationReader configurationReader) {
        this.zoneManagement = zoneManagement;
        this.configurationReader = configurationReader;
    }

    public synchronized void configurationChanged(ChangeEvent e) {
        try {
            String zoneName = e.getPath();
            ChangeEvent[] events = e.getDetailedChangeEvents();
            if (events == null || events.length == 0) {
                if (e.getAction() == 2) {
                    this.zoneManagement.allZonesUnregistered();
                }
            } else {
                int i = 0;
                while (i < events.length) {
                    ChangeEvent event = events[i];
                    if (event.getPath().length() > "HttpZones/".length()) {
                        zoneName = event.getPath().substring("HttpZones/".length());
                        if (e.getAction() == 2) {
                            this.zoneManagement.zoneUnregistered(zoneName);
                        } else {
                            this.configurationReader.zoneUpdated(zoneName);
                        }
                    }
                    ++i;
                }
            }
            this.zoneManagement.notifyZoneChanged();
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            Log.logWarning("Error in processing ACTION_MODIFIED event for zones configuration.", t, null);
            return;
        }
    }
}

