/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.shellcommands;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.httpserver.HostPropertiesRuntimeInterface;
import com.sap.engine.services.httpserver.HttpRuntimeInterface;
import com.sap.engine.services.httpserver.server.shellcommands.HostCommand;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class HttpAliasCommand
implements Command {
    HttpRuntimeInterface http;

    public HttpAliasCommand(HttpRuntimeInterface http) {
        this.http = http;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        int count = params.length;
        String host = null;
        String alias = null;
        String path = null;
        boolean remove = false;
        if (count > 0 && (params[0].toUpperCase().equals("-H") || params[0].equals("-?") || params[0].toUpperCase().equals("-HELP"))) {
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            int c = 0;
            while (c < count) {
                if ("-host".equals(params[c])) {
                    if (host != null) {
                        throw new Exception("Host Name Specified Twice");
                    }
                    host = params[++c];
                } else if ("-remove".equals(params[c])) {
                    if (remove) {
                        throw new Exception("Remove Specified Twice");
                    }
                    remove = true;
                } else if (alias == null) {
                    alias = params[c];
                } else if (path == null) {
                    path = params[c];
                } else {
                    throw new Exception("Path Specified Twice");
                }
                ++c;
            }
            if (host == null) {
                host = "default";
            }
            if (alias == null && remove) {
                throw new Exception("Alias Name Not Specified");
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            pw.println("ERROR: ");
            e.printStackTrace();
            pw.println();
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            HostPropertiesRuntimeInterface[] hosts = this.http.getAllHostsTemp();
            int hostIndex = -1;
            int c = hosts.length;
            while (--c >= 0) {
                if (!hosts[c].getHostName().equals(host)) continue;
                hostIndex = c;
                break;
            }
            if (hostIndex == -1) {
                throw new Exception("Virtual Host " + host + " Not Found");
            }
            if (alias == null) {
                pw.println("HTTP aliases:");
                this.listAll(pw, hosts[hostIndex], "  ");
                pw.println();
            } else {
                String oldPath = hosts[hostIndex].getAliasValue(alias);
                if (remove) {
                    if (oldPath == null) {
                        pw.println("HTTP Alias " + alias + " Not Found");
                    } else {
                        hosts[hostIndex].removeHttpAlias(alias);
                    }
                } else if (path != null) {
                    hosts[hostIndex].addHttpAlias(alias, path);
                    pw.println("Alias " + alias + " added successfully");
                } else {
                    if (oldPath == null) {
                        throw new Exception("HTTP Alias " + alias + " Not Found");
                    }
                    this.list(pw, alias, oldPath, "  ");
                }
            }
            this.http.clearCache(host);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            pw.println("ERROR: ");
            e.printStackTrace();
        }
    }

    private void listAll(PrintWriter pw, HostPropertiesRuntimeInterface hostProperties, String tab) throws Exception {
        String[] en = hostProperties.getAliasNames();
        int i = 0;
        while (en != null && i < en.length) {
            if (!hostProperties.isApplicationAlias(en[i])) {
                this.list(pw, en[i], hostProperties.getAliasValue(en[i]), tab);
            }
            ++i;
        }
    }

    private void list(PrintWriter pw, String alias, Object path, String tab) throws Exception {
        if (path == null) {
            pw.println(tab + alias);
        } else {
            pw.println(tab + alias + " -> " + HostCommand.p(path));
        }
    }

    public String getName() {
        return "HTTP_ALIAS";
    }

    public String getGroup() {
        return "http";
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        return "Manages http aliases" + nl + "USAGE: " + this.getName() + " [-host <hostName>] <alias> [path] [-remove]" + nl + nl + "Parameters:" + nl + "  -host <hostName>      The virtual host name. If it is not specified, the default host is displayed" + nl + "  <alias>               The alias name. If only <alias> is specified the command returns the alias path>" + nl + "  <path>                The alias path" + nl + "  -remove               Removes the alias" + nl + nl + "Used without parameters the command lists all http aliases with their paths" + nl;
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

