/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.shellcommands;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.httpserver.interfaces.HttpProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class HTTPClearCache
implements Command {
    private HttpProvider http;

    public HTTPClearCache(HttpProvider http) {
        this.http = http;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        int count = params.length;
        if (count != 0 || count > 0 && (params[0].toUpperCase().equals("-H") || params[0].equals("-?") || params[0].toUpperCase().equals("-HELP"))) {
            pw.println(this.getHelpMessage());
        } else {
            try {
                this.http.clearCache();
                pw.println("\nHTTPCache cleared.");
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                pw.println("ERROR: ");
                e.printStackTrace();
                pw.println(this.getHelpMessage());
                return;
            }
        }
    }

    public String getName() {
        return "CLEAR_HTTP_CACHE";
    }

    public String getGroup() {
        return "http";
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        return "Removes all files in the cache previously stored there by the HTTP Service. " + nl + "When using the cache, if a file has been modified the cache returns the " + nl + "previous content (not the modified one). For a modification to take effect " + nl + "the cache has to be cleared first and then it will cache the new content. " + nl + "Usage: " + this.getName() + "";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

