/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.shellcommands;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.httpserver.HostPropertiesRuntimeInterface;
import com.sap.engine.services.httpserver.HttpRuntimeInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class ApplicationAliasCommand
implements Command {
    private HttpRuntimeInterface http = null;
    private ApplicationServiceContext context = null;

    public ApplicationAliasCommand(ApplicationServiceContext context, HttpRuntimeInterface http) {
        this.http = http;
        this.context = context;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        PrintWriter pw = new PrintWriter(output, true);
        int count = params.length;
        String host = null;
        String alias = null;
        boolean disable = false;
        boolean enable = false;
        boolean printAppName = false;
        if (count > 0 && (params[0].toUpperCase().equals("-H") || params[0].equals("-?") || params[0].toUpperCase().equals("-HELP"))) {
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            int c = 0;
            while (c < count) {
                if ("-host".equals(params[c])) {
                    if (host != null) {
                        throw new Exception("Host name specified twice");
                    }
                    host = params[++c];
                } else if ("-disable".equals(params[c])) {
                    if (disable) {
                        throw new Exception("Disable specified twice");
                    }
                    if (enable) {
                        throw new Exception("Both parameter disable and enable specified");
                    }
                    disable = true;
                } else if ("-enable".equals(params[c])) {
                    if (enable) {
                        throw new Exception("Enable specified twice");
                    }
                    if (disable) {
                        throw new Exception("Both parameter disable and enable specified");
                    }
                    enable = true;
                } else if ("-printAppName".equalsIgnoreCase(params[c])) {
                    if (printAppName) {
                        throw new Exception("-printAppName must appear only once!");
                    }
                    printAppName = true;
                } else if (alias == null) {
                    alias = params[c];
                } else {
                    throw new Exception("Alias name specified twice");
                }
                ++c;
            }
            if (host == null) {
                host = "default";
            }
            if (alias == null && (disable || enable)) {
                throw new Exception("Alias Name Not Specified");
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            pw.print("ERROR: ");
            e.printStackTrace(pw);
            pw.println();
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            HostPropertiesRuntimeInterface[] hosts = this.http.getAllHostsTemp();
            int hostIndex = -1;
            int c = hosts.length;
            while (--c >= 0) {
                if (!hosts[c].getHostName().equals(host)) continue;
                hostIndex = c;
                break;
            }
            if (hostIndex == -1) {
                throw new Exception("Virtual Host " + host + " Not Found");
            }
            if (printAppName) {
                if (null == alias) {
                    this.listAllByAppName(pw, hosts[hostIndex]);
                } else {
                    this.findAppNameByAlias(pw, hosts[hostIndex], alias);
                }
                return;
            }
            if (alias == null) {
                pw.println("Application Aliases:");
                this.listAll(pw, hosts[hostIndex], host, "  ");
            } else {
                if (enable && !hosts[hostIndex].isApplicationAliasEnabled(alias)) {
                    hosts[hostIndex].enableApplicationAlias(alias);
                    pw.println("Application Aliases:");
                    this.listAll(pw, hosts[hostIndex], host, "  ");
                    this.http.clearCache(host);
                } else if (disable && hosts[hostIndex].isApplicationAliasEnabled(alias)) {
                    hosts[hostIndex].disableApplicationAlias(alias);
                    pw.println("Application Aliases:");
                    this.listAll(pw, hosts[hostIndex], host, "  ");
                    this.http.clearCache(host);
                }
                if (hosts[hostIndex].isApplicationAliasEnabled(alias)) {
                    pw.println();
                    pw.println("Application alias " + alias + " is available on " + host + " host");
                } else {
                    pw.println();
                    pw.println("Application alias " + alias + " is not available on " + host + " host");
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            pw.println("ERROR: ");
            e.printStackTrace(pw);
        }
    }

    private void listAll(PrintWriter pw, HostPropertiesRuntimeInterface hostProperties, String host, String tab) throws RemoteException {
        String[] en = hostProperties.getAliasNames();
        int i = 0;
        while (en != null && i < en.length) {
            String alias = en[i];
            if (hostProperties.isApplicationAlias(alias)) {
                if (hostProperties.isApplicationAliasEnabled(alias)) {
                    pw.println(tab + alias + tab + "- (active on " + host + " host)");
                } else {
                    pw.println(tab + alias + tab + "- (inactive on " + host + " host)");
                }
            }
            ++i;
        }
    }

    private void listAllByAppName(PrintWriter writer, HostPropertiesRuntimeInterface hostProperties) throws RemoteException {
        this.printHeader(writer);
        String container = "servlet_jsp";
        String[] servers = new String[]{this.context.getClusterContext().getClusterMonitor().getCurrentParticipant().getName()};
        DeployService deploy = (DeployService)this.context.getContainerContext().getObjectRegistry().getServiceInterface("deploy");
        String[] apps = deploy.listApplications(container, servers);
        int i = 0;
        while (i < apps.length) {
            String app = apps[i];
            this.printAppName(app, deploy.getApplicationStatus(app, servers[0]), writer);
            String[] elements = deploy.listElements(container, app, servers);
            int j = 0;
            while (j < elements.length) {
                String element = elements[j];
                String alias = element.substring(0, element.lastIndexOf(" - web"));
                if (hostProperties.isApplicationAlias(alias)) {
                    this.printAlias(alias, hostProperties.isApplicationAliasEnabled(alias), hostProperties.getHostName(), writer);
                }
                ++j;
            }
            ++i;
        }
    }

    private void findAppNameByAlias(PrintWriter writer, HostPropertiesRuntimeInterface hostProperties, String aliasToFind) throws RemoteException {
        this.printHeader(writer);
        String container = "servlet_jsp";
        String[] servers = new String[]{this.context.getClusterContext().getClusterMonitor().getCurrentParticipant().getName()};
        DeployService deploy = (DeployService)this.context.getContainerContext().getObjectRegistry().getServiceInterface("deploy");
        String[] apps = deploy.listApplications(container, servers);
        int i = 0;
        while (i < apps.length) {
            String app = apps[i];
            String[] elements = deploy.listElements(container, app, servers);
            int j = 0;
            while (j < elements.length) {
                String element = elements[j];
                String alias = element.substring(0, element.lastIndexOf(" - web"));
                if (hostProperties.isApplicationAlias(alias) && aliasToFind.equals(alias)) {
                    this.printAppName(app, deploy.getApplicationStatus(app, servers[0]), writer);
                    this.printAlias(alias, hostProperties.isApplicationAliasEnabled(alias), hostProperties.getHostName(), writer);
                    return;
                }
                ++j;
            }
            ++i;
        }
        writer.print("Application alias ");
        writer.print(aliasToFind);
        writer.print(" is not available on host ");
        writer.println(hostProperties.getHostName());
    }

    private void printHeader(PrintWriter writer) {
        writer.println();
        writer.println("APPLICATION/ALIAS                                   STATUS");
        writer.println("----------------------------------------------------------------------");
    }

    private void printAppName(String appName, String status, PrintWriter writer) {
        writer.print("\u001b[36;1m");
        writer.print(appName);
        writer.print("  ");
        this.printChar(' ', 50 - appName.length(), writer);
        writer.print("STOPPED".equals(status) ? "\u001b[31;1m" : "\u001b[36;1m");
        writer.print(status);
        writer.println("\u001b[37;0m");
    }

    private void printAlias(String alias, boolean enabled, String host, PrintWriter writer) {
        writer.print("  ");
        writer.print(alias);
        writer.print("  ");
        this.printChar(' ', 50 - alias.length() - 2, writer);
        writer.print(enabled ? "\u001b[37;0m" : "\u001b[31;1m");
        writer.print(enabled ? "active" : "inactive");
        writer.println("\u001b[37;0m");
    }

    private void printChar(char ch, int length, PrintWriter writer) {
        int i = 0;
        while (i < length) {
            writer.print(ch);
            ++i;
        }
    }

    public String getName() {
        return "APPLICATION_ALIAS";
    }

    public String getGroup() {
        return "http";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        return "Manages application aliases" + nl + "USAGE: " + this.getName() + " [-host <hostName>] <aliasName> [-disable | -enable] [-printAppName]" + nl + nl + "Parameters:" + nl + "  -host <host name>      The virtual host name. If it is not specified, the default host is displayed" + nl + "  <aliasName>            The name of an alias on the virtual host" + nl + "  -disable               Disable the alias on the specific host" + nl + "  -enable                Enable the alias on the specific host" + nl + "  -printAppName          If alias is available - the name of the application" + nl + "                         that owns this alias, else - list of application " + nl + "                         aliases grouped by application" + nl + nl + "Used without parameters the command lists all application aliases available on " + nl + "the virtual host (if specified)." + nl + "If only <aliasName> is specified the command returns if this alias is available" + nl + "on the virtual host" + nl;
    }
}

