/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.properties;

import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.HttpParseUtil;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.logongroups.LogonTable;
import com.sap.engine.services.httpserver.server.properties.HttpCompressedProperties;
import com.sap.engine.services.httpserver.server.properties.MimeMappings;
import com.sap.engine.services.httpserver.server.properties.ProxyServersProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class HttpProperties {
    private static final String LOG_CLF_KEY = "LogCLF";
    private static final String FILE_BUFFER_SIZE_KEY = "FileBufferSize";
    private static final String MIN_FILE_LENGTH_FOR_LDT = "MinFileLengthForLongDataTransfer";
    private static final String SERVLETS_LONG_DATA_TRANSFER_LIMIT = "ServletsLongDataTransferLimit";
    private static final String SERVLETS_LONG_DATA_TRANSFER_TIMEOUT = "ServletsLongDataTransferTimeout";
    private static final String MIME_TYPES_KEY = "Mime";
    private static final String INFER_NAMES_KEY = "InferNames";
    private static final String CACHE_TIMEOUT_KEY = "CacheTimeOut";
    private static final String CACHE_SIZE_KEY = "CacheSize";
    private static final String MAX_FILE_LENGTH_FOR_CACHE_KEY = "MaxFileLengthForCache";
    private static final String CACHE_CONTROL_KEY = "CacheControl";
    private static final String SAP_CACHE_CONTROL_KEY = "SapCacheControl";
    private static final String SERVLET_INPUT_STREAM_TIMEOUT_KEY = "ServletInputStreamTimeout";
    private static final String PROTOCOL_HEADER_NAME_KEY = "ProtocolHeaderName";
    private static final String ACCEPT_CLIENT_CERT_WITHOUT_SSL_KEY = "AcceptClientCertWithoutSSL";
    private static final String PROXY_SERVERS_CERTIFICATES_KEY = "ProxyServersCertificates";
    private static final String CLIENT_CERT_HEADER_NAME_KEY = "ClientCertificateHeaderName";
    private static final String CLIENT_CERT_CHAIN_HEADER_PREFIX_KEY = "ClientCertificateChainHeaderPrefix";
    private static final String CLIENT_KEY_SIZE_HEADER_NAME_KEY = "ClientKeySizeHeaderName";
    private static final String CLIENT_CIPHER_SUITE_HEADER_NAME_KEY = "ClientCipherSuiteHeaderName";
    private static final String USE_SERVER_HEADER = "UseServerHeader";
    private static final String INPUT_BUFFER_MINSIZE = "InputBufferMinSize";
    private static final String INPUT_BUFFER_MAXSIZE = "InputBufferMaxSize";
    private static final String ZONE_SEPARATOR = "ZoneSeparator";
    private static final String LOG_RESPONSE_TIME = "LogResponseTime";
    private static final String LOG_HEADER_VALUE = "LogHeaderValue";
    private static final String CLIENT_IP_HEADER_NAME_KEY = "ClientIpHeaderName";
    private static final String LOAD_BALANCING_COOKIE_PREFIX = "LoadBalancingCookiePrefix";
    private static final String GROUP_INFO_LOCATION = "GroupInfoLocation";
    private static final String URL_MAP_LOCATION = "UrlMapLocation";
    protected static final String GZIP_IMPLEMENTATION = "GZipOutputStreamImplementation";
    protected static final String ALWAYS_COMPRESS_KEY = "AlwaysCompressed";
    protected static final String NEVER_COMPRESS_KEY = "NeverCompressed";
    protected static final String COMPRESSED_OTHERS_KEY = "CompressedOthers";
    protected static final String MINIMUM_GZIP_LENGTH_KEY = "MinimumGZipLength";
    protected static final String MAXIMUM_COMPRESSED_URL_LENGTH_KEY = "MaximumCompressedURLLength";
    protected static final int MAXIMUM_COMPRESSED_URL_LENGTH_DEFAULT = -1;
    private boolean logInCLF = false;
    private int fileBufferSize = 4096;
    private int minLengthForLongData = 204800;
    private int servletsLongDataTransferLimit = 131072;
    private int servletsLongDataTransferTimeout = 10000;
    private MimeMappings mimeTypes = new MimeMappings();
    private String[] infernames = new String[]{"index.html", "index.htm", "default.html", "default.htm"};
    private long cacheTimeout = -1L;
    private int maxCacheFileSize = 16348;
    private int cacheSize = 1000;
    private long sapCacheValidationTime = 86400L;
    private long cacheValidationTime = 86400L;
    private byte[] cacheValidationTimeBytes = "max-age=86400".getBytes();
    private String cacheValidationTimeString = "max-age=86400";
    private int servletInputTimeout = 10000;
    private boolean useServerHeader = true;
    private int inputBufferMinSize = 0x100000;
    private int inputBufferMaxSize = 0x800000;
    private String zoneSeparator = "~";
    private boolean logResponseTime = false;
    private String logHeaderValue = null;
    private ProxyServersProperties proxyServersProperties = new ProxyServersProperties();
    private HttpCompressedProperties compressedProperties = new HttpCompressedProperties();
    private String clientIpHeaderName = null;
    private Log log = null;
    private String loadBalancingCookiePrefix = "saplb_";
    private String groupInfoLocation = null;
    private String urlMapLocation = null;
    private LogonTable logonTable = new LogonTable();

    public void setLog(Log log) {
        this.log = log;
    }

    public boolean logInCLF() {
        return this.logInCLF;
    }

    public int getFileBufferSize() {
        return this.fileBufferSize;
    }

    public int getMinLengthForLongData() {
        return this.minLengthForLongData;
    }

    public int getServletsLongDataTransferLimit() {
        return this.servletsLongDataTransferLimit;
    }

    public int getServletsLongDataTransferTimeout() {
        return this.servletsLongDataTransferTimeout;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getMaxCacheFileSize() {
        return this.maxCacheFileSize;
    }

    public long getSapCacheValidationTime() {
        return this.sapCacheValidationTime;
    }

    public long getCacheValidationTime() {
        return this.cacheValidationTime;
    }

    public byte[] getCacheValidationTimeBytes() {
        return this.cacheValidationTimeBytes;
    }

    public String getCacheValidationTimeString() {
        return this.cacheValidationTimeString;
    }

    public int getServletInputStreamTimeout() {
        return this.servletInputTimeout;
    }

    public String[] getInfernames() {
        return this.infernames;
    }

    public boolean getUseServerHeader() {
        return this.useServerHeader;
    }

    public int getInputBufferMinSize() {
        return this.inputBufferMinSize;
    }

    public int getInputBufferMaxSize() {
        return this.inputBufferMaxSize;
    }

    public String getZoneSeparator() {
        return this.zoneSeparator;
    }

    public boolean logResponseTime() {
        return this.logResponseTime;
    }

    public String getLogHeaderValue() {
        return this.logHeaderValue;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeTypes;
    }

    public ProxyServersProperties getProxyServersProperties() {
        return this.proxyServersProperties;
    }

    public HttpCompressedProperties getHttpCompressedProperties() {
        return this.compressedProperties;
    }

    public String getClientIpHeaderName() {
        return this.clientIpHeaderName;
    }

    public String getLoadBalancingCookiePrefix() {
        return this.loadBalancingCookiePrefix;
    }

    public LogonTable getLogonTable() {
        return this.logonTable;
    }

    public void setProperties(Properties properties) {
        Enumeration en = ((Hashtable)properties).keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            try {
                this.setProperty(key, (String)((Hashtable)properties).get(key));
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.log.logError("Cannot read and initialize property [" + key + "] of Http Provider service.", e, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setProperty(String key, String value) {
        block132: {
            if ("LogCLF".equals(key)) {
                this.logInCLF = new Boolean(value);
            } else if ("FileBufferSize".equals(key)) {
                try {
                    this.fileBufferSize = new Integer(value);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.fileBufferSize = 4096;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.fileBufferSize + "].", e, null);
                }
            } else if ("CacheTimeOut".equals(key)) {
                try {
                    this.cacheTimeout = new Long(value) * 1000L;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.cacheTimeout = -1L;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.cacheTimeout + "].", e, null);
                }
            } else if ("AcceptClientCertWithoutSSL".equals(key)) {
                this.proxyServersProperties.setAcceptClientCertWithoutSSL(new Boolean(value));
            } else if ("ClientCertificateHeaderName".equals(key)) {
                this.proxyServersProperties.setClientCertificateHeaderName(value.trim().getBytes());
            } else if ("ClientCertificateChainHeaderPrefix".equals(key)) {
                this.proxyServersProperties.setClientCertificateChainHeaderPrefix(value.trim());
            } else if ("ClientCipherSuiteHeaderName".equals(key)) {
                this.proxyServersProperties.setClientCipherSuiteHeaderName(value.trim().getBytes());
            } else if ("ClientKeySizeHeaderName".equals(key)) {
                this.proxyServersProperties.setClientKeySizeHeaderName(value.trim().getBytes());
            } else if ("ProxyServersCertificates".equals(key)) {
                this.proxyServersProperties.setProxyCertificatesNames(HttpParseUtil.stringToList(value));
            } else if ("ServletInputStreamTimeout".equals(key)) {
                try {
                    this.servletInputTimeout = new Integer(value);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.servletInputTimeout = 10000;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.servletInputTimeout + "].", e, null);
                }
            } else if ("ProtocolHeaderName".equals(key)) {
                this.proxyServersProperties.setProtocolHeaderName(value.trim());
            } else if ("GZipOutputStreamImplementation".equals(key)) {
                this.compressedProperties.setGZipImplementation(value);
            } else if ("AlwaysCompressed".equals(key)) {
                this.compressedProperties.setAlwaysCompressedExtensions(HttpParseUtil.commpressedStringToExtensions(value));
                this.compressedProperties.setAlwaysCompressedMIMETypes(HttpParseUtil.commpressedStringToMIMEType(value));
                this.compressedProperties.initGzipSettings();
            } else if ("NeverCompressed".equals(key)) {
                this.compressedProperties.setNeverCompressedExtensions(HttpParseUtil.commpressedStringToExtensions(value));
                this.compressedProperties.setNeverCompressedMIMETypes(HttpParseUtil.commpressedStringToMIMEType(value));
                this.compressedProperties.initGzipSettings();
            } else if ("CompressedOthers".equals(key)) {
                this.compressedProperties.setCompressedOthers(new Boolean(value));
            } else if ("MinimumGZipLength".equals(key)) {
                try {
                    this.compressedProperties.setMinGZipLength(Integer.parseInt(value));
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.compressedProperties.setMinGZipLength(8192);
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.compressedProperties.getMinGZipLength() + "].", e, null);
                }
            } else if ("MaximumCompressedURLLength".equals(key)) {
                try {
                    this.compressedProperties.setMaximumCompressURLLength(Integer.parseInt(value));
                }
                catch (Exception e) {
                    this.compressedProperties.setMaximumCompressURLLength(-1);
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + -1 + "].", e, null);
                }
            } else if ("Mime".equalsIgnoreCase(key)) {
                this.mimeTypes.initMimeMappings(HttpParseUtil.stringToHashtable(value));
            } else if ("MinFileLengthForLongDataTransfer".equalsIgnoreCase(key)) {
                try {
                    this.minLengthForLongData = new Integer(value);
                }
                catch (Exception e) {
                    this.minLengthForLongData = 204800;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.minLengthForLongData + "].", e, null);
                }
            } else if ("ServletsLongDataTransferLimit".equalsIgnoreCase(key)) {
                try {
                    this.servletsLongDataTransferLimit = new Integer(value);
                }
                catch (Exception e) {
                    this.servletsLongDataTransferLimit = 131072;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.servletsLongDataTransferLimit + "].", e, null);
                }
            } else if ("ServletsLongDataTransferTimeout".equalsIgnoreCase(key)) {
                try {
                    this.servletsLongDataTransferTimeout = new Integer(value);
                }
                catch (Exception e) {
                    this.servletsLongDataTransferTimeout = 10000;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.servletsLongDataTransferTimeout + "].", e, null);
                }
            } else if ("SapCacheControl".equalsIgnoreCase(key)) {
                try {
                    this.sapCacheValidationTime = new Long(value);
                }
                catch (NumberFormatException e) {
                    this.sapCacheValidationTime = 86400L;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.sapCacheValidationTime + "].", e, null);
                }
            } else if ("CacheControl".equalsIgnoreCase(key)) {
                try {
                    this.cacheValidationTime = new Long(value);
                }
                catch (NumberFormatException e) {
                    this.cacheValidationTime = 86400L;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.cacheValidationTime + "].", e, null);
                }
                this.cacheValidationTimeString = "max-age=" + this.cacheValidationTime;
                this.cacheValidationTimeBytes = this.cacheValidationTimeString.getBytes();
            } else if ("CacheSize".equalsIgnoreCase(key)) {
                try {
                    this.cacheSize = new Integer(value);
                }
                catch (Exception e) {
                    this.cacheSize = 1000;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.cacheSize + "].", e, null);
                }
            } else if ("MaxFileLengthForCache".equalsIgnoreCase(key)) {
                try {
                    this.maxCacheFileSize = new Integer(value);
                    if (this.maxCacheFileSize <= -1) {
                        this.maxCacheFileSize = 16348;
                        this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.maxCacheFileSize + "].", null);
                    }
                }
                catch (Exception e) {
                    this.maxCacheFileSize = 16348;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.maxCacheFileSize + "].", e, null);
                }
            } else if ("InferNames".equalsIgnoreCase(key)) {
                try {
                    this.infernames = HttpParseUtil.stringToArray(value);
                    break block132;
                }
                catch (IllegalArgumentException e) {
                    infernamesAll = "";
                    i = 0;
                    ** while (this.infernames != null && i < this.infernames.length)
                }
lbl-1000:
                // 1 sources

                {
                    infernamesAll = infernamesAll + this.infernames[i];
                    ++i;
                    continue;
                }
lbl173:
                // 1 sources

                if (infernamesAll.endsWith(", ")) {
                    infernamesAll = infernamesAll.substring(0, infernamesAll.length() - 2);
                }
                this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + infernamesAll + "].", e, null);
            } else if ("UseServerHeader".equals(key)) {
                try {
                    this.useServerHeader = new Boolean(value);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.useServerHeader = true;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.useServerHeader + "].", e, null);
                }
            } else if ("InputBufferMinSize".equals(key)) {
                try {
                    this.inputBufferMinSize = new Integer(value) * 1024;
                }
                catch (Exception e) {
                    this.inputBufferMinSize = 0x100000;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.inputBufferMinSize + "].", e, null);
                }
            } else if ("InputBufferMaxSize".equals(key)) {
                try {
                    this.inputBufferMaxSize = new Integer(value) * 1024;
                }
                catch (Exception e) {
                    this.inputBufferMaxSize = 0x800000;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.inputBufferMaxSize + "].", e, null);
                }
            } else if ("ZoneSeparator".equals(key)) {
                try {
                    this.zoneSeparator = value;
                    if (this.zoneSeparator == null) break block132;
                    this.zoneSeparator = this.zoneSeparator.trim();
                    if (this.zoneSeparator.length() == 0) {
                        this.zoneSeparator = null;
                    }
                }
                catch (Exception e) {
                    this.zoneSeparator = "~";
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.zoneSeparator + "].", e, null);
                }
            } else if ("LogResponseTime".equals(key)) {
                this.logResponseTime = new Boolean(value);
            } else if ("LogHeaderValue".equals(key)) {
                this.logHeaderValue = value.trim();
                if (this.logHeaderValue.equals("")) {
                    this.logHeaderValue = null;
                }
            } else if ("ClientIpHeaderName".equals(key)) {
                try {
                    this.clientIpHeaderName = value;
                    if (this.clientIpHeaderName == null) break block132;
                    this.clientIpHeaderName = this.clientIpHeaderName.trim();
                    if (this.clientIpHeaderName.length() == 0) {
                        this.clientIpHeaderName = null;
                    }
                }
                catch (Exception e) {
                    this.clientIpHeaderName = null;
                    this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found. Will use default one [" + this.clientIpHeaderName + "].", e, null);
                }
            } else if ("LoadBalancingCookiePrefix".equals(key)) {
                CookieParser.app_cookie_prefix = this.loadBalancingCookiePrefix = value.trim();
                CookieParser.app_cookie_prefix_ = CookieParser.app_cookie_prefix.getBytes();
            } else if ("GroupInfoLocation".equals(key)) {
                this.groupInfoLocation = value.trim();
                if (this.groupInfoLocation.length() == 0) {
                    this.groupInfoLocation = null;
                    this.logonTable.clear();
                }
                if (this.urlMapLocation != null && this.groupInfoLocation != null) {
                    try {
                        this.logonTable.loadLogonTable(this.urlMapLocation, this.groupInfoLocation);
                    }
                    catch (Exception e) {
                        this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found or logon group info file cannot be parsed.", e, null);
                    }
                }
            } else if ("UrlMapLocation".equals(key)) {
                this.urlMapLocation = value.trim();
                if (this.urlMapLocation.length() == 0) {
                    this.urlMapLocation = null;
                    this.logonTable.clear();
                }
                if (this.urlMapLocation != null && this.groupInfoLocation != null) {
                    try {
                        this.logonTable.loadLogonTable(this.urlMapLocation, this.groupInfoLocation);
                    }
                    catch (Exception e) {
                        this.log.logError("Incorrect value [" + value + "] of property [" + key + "] of Http Provider service found or logon group info file cannot be parsed.", e, null);
                    }
                }
            } else {
                this.log.logError("Unkown property read: [" + key + "], [" + value + "].", null);
            }
        }
    }
}

