/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.properties;

import com.sap.engine.services.httpserver.server.Log;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class HttpCompressedProperties {
    private static final String unknown = "[unknown]";
    private String[] alwaysCompressedExtensions = new String[]{".htm", ".html"};
    private String[] alwaysCompressedMIMETypes = new String[]{"text/html"};
    private String[] neverCompressedExtensions = new String[]{".zip", ".cs", ".rar", ".arj", ".z", ".gz", ".tar", ".lzh", ".cab", ".hqx", ".ace", ".jar", ".ear", ".war", ".css", ".pdf", ".js", ".gzip", ".uue", ".bz2", ".iso", ".sda", ".sar"};
    private String[] neverCompressedMIMETypes = new String[]{"image", "application/x-compressed", "application/zip", "application/x-gzip", "application/x-zip-compressed", "application/pdf", "content/unknown", "text/JavaScript", "[unknown]"};
    private boolean commpressedOthers = true;
    private int minimumGZipLength = 8192;
    private int maximumCompressedURLLength = -1;
    private Vector alwaysCompressedExtensionsVector = null;
    private Vector alwaysCompressedMIMETypesVector = null;
    private Vector neverCompressedExtensionsVector = null;
    private Vector neverCompressedMIMETypesVector = null;
    private static String gzipImplementation = null;
    private static Constructor gzipImpConstructor = null;
    private static Constructor gzipDeflaterConstructor = null;
    private static Constructor gzipCRC32Constructor = null;
    static /* synthetic */ Class class$java$io$OutputStream;

    public Constructor getGZipImpConstructor() {
        return gzipImpConstructor;
    }

    public String getGZipImplementation() {
        return gzipImplementation;
    }

    public Constructor getGZipDeflaterConstructor() {
        return gzipDeflaterConstructor;
    }

    public Constructor getGZipCRC32Constructor() {
        return gzipCRC32Constructor;
    }

    public void setGZipImplementation(String zipImplementation) {
        if (zipImplementation != null && !zipImplementation.trim().equals("")) {
            gzipImplementation = zipImplementation.trim();
            String deflater = gzipImplementation.substring(0, gzipImplementation.lastIndexOf(".")) + ".Deflater";
            String crc = gzipImplementation.substring(0, gzipImplementation.lastIndexOf(".")) + ".CRC32";
            try {
                gzipImpConstructor = Class.forName(gzipImplementation).getDeclaredConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = HttpCompressedProperties.class$("java.io.OutputStream")) : class$java$io$OutputStream);
                gzipDeflaterConstructor = Class.forName(deflater).getDeclaredConstructor(Integer.TYPE, Boolean.TYPE);
                gzipCRC32Constructor = Class.forName(crc).getDeclaredConstructor(new Class[0]);
                Log.logWarning("Configurable external implementation for writing compressed data in GZIP file format will be used for [" + gzipImplementation + ", " + deflater + ", " + crc + "].", null);
            }
            catch (Exception e) {
                Log.logWarning("Error configuring the external implementation for writing compressed data in GZIP file format [" + gzipImplementation + ", " + deflater + ", " + crc + "] !", e, null);
                gzipImplementation = null;
                gzipImpConstructor = null;
                gzipDeflaterConstructor = null;
                gzipCRC32Constructor = null;
            }
        } else {
            Log.logWarning("The default (JDK) implementation will be used for writing compressed data in the GZIP file format!", null);
            gzipImplementation = null;
            gzipImpConstructor = null;
            gzipDeflaterConstructor = null;
            gzipCRC32Constructor = null;
        }
    }

    public String[] getAlwaysCompressedExtensions() {
        return this.alwaysCompressedExtensions;
    }

    protected void setAlwaysCompressedExtensions(Vector alwaysCompressedExtensionsVector) {
        this.alwaysCompressedExtensionsVector = alwaysCompressedExtensionsVector;
    }

    public String[] getAlwaysCompressedMIMETypes() {
        return this.alwaysCompressedMIMETypes;
    }

    protected void setAlwaysCompressedMIMETypes(Vector alwaysCompressedMIMETypesVector) {
        this.alwaysCompressedMIMETypesVector = alwaysCompressedMIMETypesVector;
    }

    public String[] getNeverCompressedExtensions() {
        return this.neverCompressedExtensions;
    }

    protected void setNeverCompressedExtensions(Vector neverCompressedExtensionsVector) {
        this.neverCompressedExtensionsVector = neverCompressedExtensionsVector;
    }

    public String[] getNeverCompressedMIMETypes() {
        return this.neverCompressedMIMETypes;
    }

    protected void setNeverCompressedMIMETypes(Vector neverCompressedMIMETypesVector) {
        this.neverCompressedMIMETypesVector = neverCompressedMIMETypesVector;
    }

    public boolean isCompressedOthers() {
        return this.commpressedOthers;
    }

    public void setCompressedOthers(boolean commpressedOthers) {
        this.commpressedOthers = commpressedOthers;
    }

    public int getMinGZipLength() {
        return this.minimumGZipLength;
    }

    public void setMaximumCompressURLLength(int urlLength) {
        this.maximumCompressedURLLength = urlLength;
    }

    public int getMaximumCompressedURLLength() {
        return this.maximumCompressedURLLength;
    }

    public boolean isGzip(String fileName, String contentTypeHeader) {
        int i;
        if (contentTypeHeader == null) {
            contentTypeHeader = unknown;
        }
        int i2 = 0;
        while (i2 < this.getAlwaysCompressedMIMETypes().length) {
            if (contentTypeHeader.startsWith(this.getAlwaysCompressedMIMETypes()[i2])) {
                return true;
            }
            ++i2;
        }
        if (fileName != null) {
            i = 0;
            while (i < this.getAlwaysCompressedExtensions().length) {
                if (fileName.endsWith(this.getAlwaysCompressedExtensions()[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (!this.isCompressedOthers()) {
            return false;
        }
        i = 0;
        while (i < this.getNeverCompressedMIMETypes().length) {
            if (contentTypeHeader.startsWith(this.getNeverCompressedMIMETypes()[i])) {
                return false;
            }
            ++i;
        }
        if (fileName == null) {
            return true;
        }
        int i3 = 0;
        while (i3 < this.getNeverCompressedExtensions().length) {
            if (fileName.endsWith(this.getNeverCompressedExtensions()[i3])) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    protected void setMinGZipLength(int minimumGZipLength) {
        this.minimumGZipLength = minimumGZipLength;
    }

    protected void initGzipSettings() {
        int i;
        if (this.alwaysCompressedExtensionsVector != null && this.alwaysCompressedExtensionsVector.size() != 0 && this.neverCompressedExtensionsVector != null && this.neverCompressedExtensionsVector.size() != 0) {
            i = 0;
            while (i < this.alwaysCompressedExtensionsVector.size()) {
                if (this.neverCompressedExtensionsVector.contains(this.alwaysCompressedExtensionsVector.elementAt(i))) {
                    Log.logWarning(this.alwaysCompressedExtensionsVector.elementAt(i) + " entry exsits in " + "AlwaysCompressed" + " and " + "NeverCompressed" + " lists. It will be remove from both lists and will be treated according to " + "CompressedOthers" + " property.", null);
                    this.neverCompressedExtensionsVector.remove(this.alwaysCompressedExtensionsVector.elementAt(i));
                    this.alwaysCompressedExtensionsVector.removeElementAt(i--);
                }
                ++i;
            }
        }
        if (this.alwaysCompressedMIMETypesVector != null && this.alwaysCompressedMIMETypesVector.size() != 0 && this.neverCompressedMIMETypesVector != null && this.neverCompressedMIMETypesVector.size() != 0) {
            i = 0;
            while (i < this.alwaysCompressedMIMETypesVector.size()) {
                if (this.neverCompressedMIMETypesVector.contains(this.alwaysCompressedMIMETypesVector.elementAt(i))) {
                    Log.logWarning(this.alwaysCompressedMIMETypesVector.elementAt(i) + " entry exsits in " + "AlwaysCompressed" + " and " + "NeverCompressed" + " lists. It will be remove from both lists and will be treated according to " + "CompressedOthers" + " property.", null);
                    this.neverCompressedMIMETypesVector.remove(this.alwaysCompressedMIMETypesVector.elementAt(i));
                    this.alwaysCompressedMIMETypesVector.removeElementAt(i--);
                }
                ++i;
            }
        }
        if (this.alwaysCompressedExtensionsVector == null) {
            this.alwaysCompressedExtensions = new String[0];
        } else {
            this.alwaysCompressedExtensions = new String[this.alwaysCompressedExtensionsVector.size()];
            i = 0;
            while (i < this.alwaysCompressedExtensionsVector.size()) {
                this.alwaysCompressedExtensions[i] = (String)this.alwaysCompressedExtensionsVector.elementAt(i);
                ++i;
            }
        }
        if (this.alwaysCompressedMIMETypesVector == null) {
            this.alwaysCompressedMIMETypes = new String[0];
        } else {
            this.alwaysCompressedMIMETypes = new String[this.alwaysCompressedMIMETypesVector.size()];
            i = 0;
            while (i < this.alwaysCompressedMIMETypesVector.size()) {
                this.alwaysCompressedMIMETypes[i] = (String)this.alwaysCompressedMIMETypesVector.elementAt(i);
                ++i;
            }
        }
        if (this.neverCompressedExtensionsVector == null) {
            this.neverCompressedExtensions = new String[0];
        } else {
            this.neverCompressedExtensions = new String[this.neverCompressedExtensionsVector.size()];
            i = 0;
            while (i < this.neverCompressedExtensionsVector.size()) {
                this.neverCompressedExtensions[i] = (String)this.neverCompressedExtensionsVector.elementAt(i);
                ++i;
            }
        }
        if (this.neverCompressedMIMETypesVector == null) {
            this.neverCompressedMIMETypes = new String[0];
        } else {
            this.neverCompressedMIMETypes = new String[this.neverCompressedMIMETypesVector.size()];
            i = 0;
            while (i < this.neverCompressedMIMETypesVector.size()) {
                this.neverCompressedMIMETypes[i] = (String)this.neverCompressedMIMETypesVector.elementAt(i);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

