/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.logongroups.descriptor;

import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.server.logongroups.descriptor.AliasInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class URLInfoConfig {
    public static final double VERSION = 1.0;
    private static final String VERSION_LINE = "version 1.0";
    private double version = 1.0;
    private Hashtable aliases = new Hashtable();
    private String fileLocation = null;

    private void init() {
        this.version = 1.0;
        this.aliases = new Hashtable();
    }

    public Vector getAllAliases() {
        Vector res = new Vector();
        res.addAll(this.aliases.keySet());
        return res;
    }

    public AliasInfo getAliasInfo(String alias) {
        return (AliasInfo)this.aliases.get(alias);
    }

    public void loadFromFile(String fileLocation) throws IOException, ParseException {
        this.setFileLocation(fileLocation);
        this.loadFromFile();
    }

    public void loadFromFile() throws IOException, ParseException {
        if (this.fileLocation == null) {
            throw new IOException("File location not set [" + this.fileLocation + "].");
        }
        this.init();
        FileReader fileReader = new FileReader(this.fileLocation);
        try {
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.parseVersionLine(bufferedReader.readLine());
            String nextLine = bufferedReader.readLine();
            while (this.parseUrlInfo(nextLine)) {
                nextLine = bufferedReader.readLine();
            }
            nextLine = bufferedReader.readLine();
            if (nextLine != null) {
                throw new ParseException("Illegal logon groups file format. Line [" + nextLine + "] not expected here.");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileReader.close();
            throw throwable;
        }
        fileReader.close();
    }

    public void saveToFile() throws IOException {
        if (this.fileLocation == null) {
            throw new IOException("File location not set [" + this.fileLocation + "].");
        }
        File file = new File(this.fileLocation);
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        FileWriter fileWriter = new FileWriter(this.fileLocation);
        try {
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(VERSION_LINE);
            Enumeration en = this.aliases.keys();
            while (en.hasMoreElements()) {
                AliasInfo aliasInfo = (AliasInfo)en.nextElement();
                printWriter.println(aliasInfo.toAliasInfoConfigLine());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fileWriter.close();
            throw throwable;
        }
        fileWriter.close();
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    private void parseVersionLine(String versionLine) throws ParseException {
        if (versionLine == null) {
            throw new ParseException("Illegal url info file format. Leading line [Version 1.0] not found. File is: [" + this.fileLocation + "], line read: [" + versionLine + "].");
        }
        if (!VERSION_LINE.equals(versionLine = versionLine.trim())) {
            throw new ParseException("Illegal url info file format. Leading line [Version 1.0] not found. File is: [" + this.fileLocation + "], line read: [" + versionLine + "], " + "line expected: [" + VERSION_LINE + "].");
        }
        this.version = 1.0;
    }

    private boolean parseUrlInfo(String nextLine) throws ParseException {
        if (nextLine == null) {
            return false;
        }
        if ((nextLine = nextLine.trim()).length() == 0) {
            return false;
        }
        AliasInfo aliasInfo = new AliasInfo();
        aliasInfo.initAliasInfo(nextLine);
        this.aliases.put(aliasInfo.getAliasName(), aliasInfo);
        return true;
    }

    public void clear() {
        this.init();
    }
}

