/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.logongroups.descriptor;

import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.server.logongroups.descriptor.LogonGroup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogonGroupsConfig {
    public static final double VERSION = 1.0;
    private static final String VERSION_LINE = "version 1.0";
    private double version = 1.0;
    private Vector allInstances = null;
    private Hashtable logonGroups = null;
    private String fileLocation = null;

    public LogonGroupsConfig() {
        this.init();
    }

    public LogonGroupsConfig(String fileLocation) {
        this.init();
        this.fileLocation = fileLocation;
    }

    private void init() {
        this.version = 1.0;
        this.allInstances = new Vector();
        this.logonGroups = new Hashtable();
    }

    public void clear() {
        this.init();
    }

    public void loadFromFile(String fileLocation) throws IOException, ParseException {
        this.setFileLocation(fileLocation);
        this.loadFromFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile() throws IOException, ParseException {
        FileReader fileReader;
        block9: {
            block8: {
                if (this.fileLocation == null) {
                    throw new IOException("File location not set [" + this.fileLocation + "].");
                }
                this.init();
                fileReader = new FileReader(this.fileLocation);
                try {
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    this.parseVersionLine(bufferedReader.readLine());
                    String nextLine = bufferedReader.readLine();
                    while (true) {
                        if (!this.parseInstance(nextLine)) {
                            if (this.parseEmptyLine(nextLine)) break;
                            Object var5_4 = null;
                            break block8;
                        }
                        nextLine = bufferedReader.readLine();
                    }
                    nextLine = bufferedReader.readLine();
                    while (true) {
                        if (!this.parseLogonGroup(nextLine)) {
                            nextLine = bufferedReader.readLine();
                            if (nextLine != null) {
                                throw new ParseException("Illegal logon groups file format. Line [" + nextLine + "] not expected here.");
                            }
                            break block9;
                        }
                        nextLine = bufferedReader.readLine();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    fileReader.close();
                    throw throwable;
                }
            }
            fileReader.close();
            return;
        }
        Object var5_5 = null;
        fileReader.close();
    }

    public void saveToFile() throws IOException {
        if (this.fileLocation == null) {
            throw new IOException("File location not set [" + this.fileLocation + "].");
        }
        Enumeration<Object> en = this.logonGroups.elements();
        while (en.hasMoreElements()) {
            this.addInstances(((LogonGroup)en.nextElement()).getInstances());
        }
        File file = new File(this.fileLocation);
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        FileWriter fileWriter = new FileWriter(this.fileLocation);
        try {
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(VERSION_LINE);
            en = this.allInstances.elements();
            while (en.hasMoreElements()) {
                printWriter.println((String)en.nextElement());
            }
            printWriter.println();
            en = this.logonGroups.elements();
            while (en.hasMoreElements()) {
                LogonGroup logonGroup = (LogonGroup)en.nextElement();
                printWriter.println(logonGroup.toLogonGroupConfigLine());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fileWriter.close();
            throw throwable;
        }
        fileWriter.close();
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setVersion(double version) {
        if (version != 1.0) {
            throw new IllegalArgumentException("Illegal version [" + version + "]. Supported versions: [" + 1.0 + "]");
        }
        this.version = version;
    }

    public double getVersion() {
        return this.version;
    }

    public void addInstance(String instance) {
        if (this.allInstances.contains(instance)) {
            return;
        }
        this.allInstances.add(instance);
    }

    public void addInstances(Vector instances) {
        Enumeration en = instances.elements();
        while (en.hasMoreElements()) {
            this.addInstance((String)en.nextElement());
        }
    }

    public Vector getInstances() {
        return this.allInstances;
    }

    public boolean containsInstance(String instance) {
        return this.allInstances.contains(instance);
    }

    public boolean removeInstance(String instance) {
        return this.allInstances.remove(instance);
    }

    public void addLogonGroup(LogonGroup logonGroup) {
        this.logonGroups.put(logonGroup.getLogonGroupName(), logonGroup);
    }

    public Hashtable getLogonGroups() {
        return this.logonGroups;
    }

    public LogonGroup getLogonGroup(String logonGroupName) {
        return (LogonGroup)this.logonGroups.get(logonGroupName);
    }

    public boolean containsLogonGroup(String logonGroupName) {
        return this.logonGroups.containsKey(logonGroupName);
    }

    public boolean removeLogonGroup(String logonGroupName) {
        return this.logonGroups.remove(logonGroupName) != null;
    }

    private void parseVersionLine(String versionLine) throws ParseException {
        if (versionLine == null) {
            throw new ParseException("Illegal logon groups file format. Leading line [Version 1.0] not found. File is: [" + this.fileLocation + "], line read: [" + versionLine + "].");
        }
        if (!VERSION_LINE.equals(versionLine = versionLine.trim())) {
            throw new ParseException("Illegal logon groups file format. Leading line [Version 1.0] not found. File is: [" + this.fileLocation + "], line read: [" + versionLine + "], " + "line expected: [" + VERSION_LINE + "].");
        }
        this.version = 1.0;
    }

    private boolean parseEmptyLine(String emptyLine) throws ParseException {
        if (emptyLine == null) {
            return false;
        }
        if ((emptyLine = emptyLine.trim()).length() > 0) {
            throw new ParseException("Illegal logon groups file format. Empty line expected, found [" + emptyLine + "].");
        }
        return true;
    }

    private boolean parseLogonGroup(String nextLine) throws ParseException {
        if (nextLine == null) {
            return false;
        }
        if ((nextLine = nextLine.trim()).length() == 0) {
            return false;
        }
        int sep = nextLine.indexOf(58);
        if (sep == -1) {
            throw new ParseException("Illegal logon groups file format. Illegal line [" + nextLine + "]. Separator [:] not found.");
        }
        String logonGroupName = nextLine.substring(0, sep);
        if (this.logonGroups.containsKey(logonGroupName = logonGroupName.trim())) {
            throw new ParseException("Illegal logon groups file format. Illegal line [" + nextLine + "]. Logon group [" + logonGroupName + "] already defined.");
        }
        LogonGroup logonGroup = new LogonGroup(logonGroupName);
        nextLine = nextLine.substring(sep + 1);
        StringTokenizer token = new StringTokenizer(nextLine, ",");
        while (token.hasMoreTokens()) {
            String nextInstance = token.nextToken().trim();
            if (!this.allInstances.contains(nextInstance)) {
                throw new ParseException("Illegal logon groups file format. Instance [" + nextInstance + "] from logon group [" + logonGroupName + "] is not declared.");
            }
            logonGroup.addInstance(nextInstance);
        }
        this.logonGroups.put(logonGroupName, logonGroup);
        return true;
    }

    private boolean parseInstance(String nextLine) {
        if (nextLine == null) {
            return false;
        }
        if ((nextLine = nextLine.trim()).length() == 0) {
            return false;
        }
        this.addInstance(nextLine);
        return true;
    }
}

