/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.logongroups.descriptor;

import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import java.util.StringTokenizer;

public class AliasInfo {
    public static final String separator = "&";
    public static final String PREFIX = "PREFIX";
    public static final String GROUP = "GROUP";
    public static final String CASE = "CASE";
    public static final String VHOST = "VHOST";
    public static final String STACK = "STACK";
    public static final String J2EE = "J2EE";
    private String aliasName = null;
    private String group = null;
    private boolean case_ = true;
    private String vhost = null;
    private String stack = null;

    public AliasInfo() {
        this.init();
    }

    public AliasInfo(String alias) {
        this.init();
        this.aliasName = alias;
    }

    private void init() {
        this.aliasName = null;
        this.group = null;
        this.case_ = true;
        this.vhost = null;
        this.stack = null;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean getCase() {
        return this.case_;
    }

    public void setCase(boolean case_) {
        this.case_ = case_;
    }

    public String getVHost() {
        return this.vhost;
    }

    public void setVHost(String vhost) {
        this.vhost = vhost;
    }

    public String getStack() {
        return this.stack;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public void initAliasInfo(String aliasInfo) throws ParseException {
        if (aliasInfo == null || aliasInfo.trim().length() == 0) {
            throw new ParseException("Illegal alias info [" + aliasInfo + "].");
        }
        StringTokenizer tokenizer = new StringTokenizer(aliasInfo = aliasInfo.trim(), separator);
        if (!tokenizer.hasMoreTokens()) {
            throw new ParseException("Illegal alias info [" + aliasInfo + "]. Alias name not found.");
        }
        this.parsePrefix(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        String next = tokenizer.nextToken();
        if (this.parseGroup(next)) {
            next = tokenizer.nextToken();
        }
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        if (this.parseCase(next)) {
            next = tokenizer.nextToken();
        }
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        if (this.parseVHost(next)) {
            next = tokenizer.nextToken();
        }
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        if (this.parseStack(next)) {
            next = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            throw new ParseException("Illegal alias info [" + aliasInfo + "]. Unknown attributes: [" + tokenizer.nextToken() + "].");
        }
    }

    public String toAliasInfoConfigLine() {
        String res = "PREFIX=/";
        if (this.aliasName != "/") {
            res = res + this.aliasName + "/" + separator;
        }
        res = res + separator;
        res = res + "GROUP=";
        if (this.group != null) {
            res = res + this.group;
        }
        res = res + separator;
        res = res + "CASE=";
        res = res + separator;
        res = res + "STACK=" + this.stack;
        return res;
    }

    private void parsePrefix(String prefix) throws ParseException {
        if (prefix == null || prefix.trim().length() == 0) {
            throw new ParseException("Illegal alias info prefix [" + prefix + "].");
        }
        int sep = (prefix = prefix.trim()).indexOf(61);
        if (sep == -1) {
            throw new ParseException("Illegal alias info syntax [" + prefix + "]. Missing [=].");
        }
        this.aliasName = prefix.substring(sep + 1);
        this.aliasName = this.aliasName.trim();
        prefix = prefix.substring(0, sep);
        if (!PREFIX.equals(prefix = prefix.trim())) {
            throw new ParseException("Illegal alias info syntax. Found [" + prefix + "]. Expected [" + PREFIX + "].");
        }
        this.aliasName = ParseUtils.convertAlias(this.aliasName);
        this.aliasName = ParseUtils.canonicalize(this.aliasName);
        if (this.aliasName.startsWith("/")) {
            this.aliasName = this.aliasName.substring(1);
        }
        if (this.aliasName.endsWith("/")) {
            this.aliasName = this.aliasName.substring(0, this.aliasName.length() - 2);
        }
    }

    private boolean parseGroup(String next) {
        if (next == null || next.trim().length() == 0) {
            return true;
        }
        int sep = (next = next.trim()).indexOf(61);
        if (sep == -1) {
            return next.startsWith(GROUP);
        }
        this.group = next.substring(sep + 1);
        this.group = this.group.trim();
        next = next.substring(0, sep);
        if (!GROUP.equals(next = next.trim())) {
            this.group = null;
            return false;
        }
        return true;
    }

    private boolean parseCase(String next) {
        if (next == null || next.trim().length() == 0) {
            return true;
        }
        int sep = (next = next.trim()).indexOf(61);
        if (sep == -1) {
            return next.startsWith(CASE);
        }
        next = next.substring(0, sep);
        return CASE.equals(next = next.trim());
    }

    private boolean parseVHost(String next) {
        if (next == null || next.trim().length() == 0) {
            return true;
        }
        int sep = (next = next.trim()).indexOf(61);
        if (sep == -1) {
            return next.startsWith(VHOST);
        }
        next = next.substring(0, sep);
        return VHOST.equals(next = next.trim());
    }

    private boolean parseStack(String next) {
        if (next == null || next.trim().length() == 0) {
            return true;
        }
        int sep = (next = next.trim()).indexOf(61);
        if (sep == -1) {
            return next.startsWith(STACK);
        }
        this.stack = next.substring(sep + 1);
        this.stack = this.stack.trim();
        next = next.substring(0, sep);
        if (!VHOST.equals(next = next.trim())) {
            this.stack = J2EE;
            return false;
        }
        return true;
    }
}

