/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.logongroups;

import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.server.logongroups.descriptor.AliasInfo;
import com.sap.engine.services.httpserver.server.logongroups.descriptor.LogonGroupsConfig;
import com.sap.engine.services.httpserver.server.logongroups.descriptor.URLInfoConfig;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class LogonTable {
    private LogonGroupsConfig logonGroupsConfig = new LogonGroupsConfig();
    private URLInfoConfig urlInfoConfig = new URLInfoConfig();

    public void loadLogonTable(String urlInfoConfigFile, String logonGroupsConfigFile) throws IOException, ParseException {
        this.logonGroupsConfig.loadFromFile(logonGroupsConfigFile);
        this.urlInfoConfig.loadFromFile(urlInfoConfigFile);
    }

    public Vector getAliases() {
        return this.urlInfoConfig.getAllAliases();
    }

    public Vector getGroups() {
        Vector res = new Vector();
        res.addAll(this.logonGroupsConfig.getLogonGroups().keySet());
        return res;
    }

    public String getGroup(String alias) {
        AliasInfo aliasInfo = this.urlInfoConfig.getAliasInfo(alias);
        if (aliasInfo == null) {
            return null;
        }
        return aliasInfo.getGroup();
    }

    public String[] getAliases(String group) {
        Vector<String> res = new Vector<String>();
        Vector allAliases = this.getAliases();
        Enumeration en = allAliases.elements();
        while (en.hasMoreElements()) {
            String alias = (String)en.nextElement();
            if (!group.equals(this.getGroup(alias))) continue;
            res.add(alias);
        }
        String[] resToString = new String[res.size()];
        en = res.elements();
        int ptr = 0;
        while (en.hasMoreElements()) {
            resToString[ptr] = (String)en.nextElement();
            ++ptr;
        }
        return resToString;
    }

    public String[] getInstances(String group) {
        Vector instances = this.logonGroupsConfig.getLogonGroup(group).getInstances();
        String[] resToString = new String[instances.size()];
        Enumeration en = instances.elements();
        int ptr = 0;
        while (en.hasMoreElements()) {
            resToString[ptr] = (String)en.nextElement();
            ++ptr;
        }
        return resToString;
    }

    public void clear() {
        this.logonGroupsConfig.clear();
        this.urlInfoConfig.clear();
    }
}

