/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.io;

import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Processor;
import java.io.OutputStream;

public class HttpOutputStream
extends OutputStream {
    private byte[] buffer = null;
    private int ptr = 0;
    private Client client = null;
    private boolean keepAll = false;
    private byte[] all = new byte[0];

    public HttpOutputStream(Client client) {
        this.client = client;
        this.buffer = Processor.poolContext.get(client.getHttpProperties().getFileBufferSize());
    }

    public void write(byte b) {
        this.buffer[this.ptr++] = b;
        if (this.ptr == this.buffer.length) {
            this.flush((byte)0);
        }
    }

    public void write(int b) {
        this.write((byte)b);
    }

    public void write(byte[] b) {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        if (b == null || off < 0 || len < 0 || off + len > b.length) {
            return;
        }
        if (len > this.buffer.length - this.ptr) {
            System.arraycopy(b, off, this.buffer, this.ptr, this.buffer.length - this.ptr);
            this.ptr += (len -= this.buffer.length - this.ptr);
            this.flush((byte)0);
            this.write(b, off += this.buffer.length - this.ptr, len);
        } else {
            System.arraycopy(b, off, this.buffer, this.ptr, len);
            this.ptr += len;
            if (this.ptr == this.buffer.length) {
                this.flush((byte)0);
            }
        }
    }

    public void flush(byte flag) {
        if (this.ptr <= 0) {
            return;
        }
        if (this.keepAll) {
            byte[] tmp = new byte[this.all.length + this.ptr];
            System.arraycopy(this.all, 0, tmp, 0, this.all.length);
            System.arraycopy(this.buffer, 0, tmp, this.all.length, this.ptr);
            this.all = tmp;
        }
        this.client.send(this.buffer, 0, this.ptr, flag);
        this.buffer = Processor.poolContext.get(this.client.getHttpProperties().getFileBufferSize());
        this.ptr = 0;
    }

    public void reset() {
        this.ptr = 0;
        if (this.keepAll) {
            this.all = new byte[0];
        }
        this.keepAll = false;
    }

    public void keepAll() {
        this.keepAll = true;
        this.all = new byte[0];
    }

    public byte[] toByteArray() {
        return this.all;
    }
}

