/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.io;

import com.sap.engine.services.httpserver.exceptions.HttpIOException;
import com.sap.engine.services.httpserver.exceptions.HttpIllegalArgumentException;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Processor;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import java.io.IOException;
import javax.servlet.ServletInputStream;

public class HttpInputStream
extends ServletInputStream {
    private static final int MAX_MARKED_COUNT = 4096;
    private HttpProperties httpProperties = null;
    private Client client = null;
    private long totalLen = -1L;
    private byte[][] content = new byte[100][];
    private int[] contentLens = new int[100];
    private int[] contentOffss = new int[100];
    private int contentPtr = 1;
    private long currentLen = -1L;
    private int ptrToArr = 0;
    private int ptr = 0;
    private long read = 0L;
    private boolean connectionClosed = false;
    private boolean marked = false;
    private boolean hasMarkedUnread = false;
    private int markedBufferReadOffset = 0;
    private byte[] markedBuffer = null;
    private int markedBufferOffset = 0;
    private boolean streamBlocked = false;

    public HttpInputStream(HttpProperties httpProperties, long totalLen, byte[] data, int dataLen, Client client) {
        this.httpProperties = httpProperties;
        this.client = client;
        this.totalLen = totalLen;
        this.content[0] = data;
        this.contentLens[0] = dataLen;
        this.contentOffss[0] = 0;
        this.currentLen = dataLen;
    }

    public HttpInputStream(HttpProperties httpProperties, byte[] data, int dataLen, Client client) {
        this.httpProperties = httpProperties;
        this.client = client;
        this.totalLen = -1L;
        this.content[0] = data;
        this.contentLens[0] = dataLen;
        this.contentOffss[0] = 0;
        this.currentLen = dataLen;
    }

    public int read() throws IOException {
        HttpInputStream httpInputStream = this;
        synchronized (httpInputStream) {
            if (this.connectionClosed) {
                throw new HttpIOException("http_0025");
            }
            if (!this.marked && this.hasMarkedUnread) {
                try {
                    int n = this.markedBuffer[this.markedBufferReadOffset++] & 0xFF;
                    Object var4_8 = null;
                    if (this.markedBufferReadOffset == this.markedBufferOffset) {
                        this.hasMarkedUnread = false;
                        this.markedBuffer = null;
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    if (this.markedBufferReadOffset == this.markedBufferOffset) {
                        this.hasMarkedUnread = false;
                        this.markedBuffer = null;
                    }
                    throw throwable;
                }
            }
            if (this.read >= this.totalLen && this.totalLen != -1L) {
                int n = -1;
                return n;
            }
            if (this.streamBlocked) {
                int limit = this.httpProperties.getInputBufferMinSize();
                if (limit < 0) {
                    limit = this.httpProperties.getInputBufferMaxSize();
                }
                if (this.currentLen - this.read < (long)limit) {
                    this.sendCallback();
                }
            }
            if (this.read >= this.currentLen) {
                if (this.connectionClosed) {
                    throw new HttpIOException("http_0025");
                }
                long startTime = System.currentTimeMillis();
                long delta = 0L;
                while (this.read >= this.currentLen && delta < (long)this.httpProperties.getServletInputStreamTimeout()) {
                    try {
                        ((Object)((Object)this)).wait(this.httpProperties.getServletInputStreamTimeout());
                    }
                    catch (IllegalMonitorStateException e) {
                        throw new HttpIOException("http_0065", e);
                    }
                    catch (InterruptedException e) {
                        throw new HttpIOException("http_0065", e);
                    }
                    delta = System.currentTimeMillis() - startTime;
                }
            }
            if (this.read >= this.currentLen) {
                if (this.totalLen == -1L) {
                    throw new HttpIOException("http_0026", new Object[]{"" + this.read, "End-Of-Chunk"});
                }
                throw new HttpIOException("http_0026", new Object[]{"" + this.read, "" + this.totalLen});
            }
            ++this.read;
            this.checkPointers();
            if (this.marked) {
                byte result = this.content[this.ptrToArr][this.ptr++];
                if (this.markedBufferOffset == this.markedBuffer.length) {
                    this.reset();
                } else {
                    this.markedBuffer[this.markedBufferOffset++] = result;
                }
                int n = result & 0xFF;
                return n;
            }
            int n = this.content[this.ptrToArr][this.ptr++] & 0xFF;
            return n;
        }
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        HttpInputStream httpInputStream = this;
        synchronized (httpInputStream) {
            if (buf == null || buf.length < off + len) {
                throw new HttpIllegalArgumentException("http_0027");
            }
            if (this.connectionClosed) {
                throw new HttpIOException("http_0025");
            }
            if (this.marked || this.hasMarkedUnread) {
                int n = super.read(buf, off, len);
                return n;
            }
            if (this.read >= this.totalLen && this.totalLen != -1L) {
                int n = -1;
                return n;
            }
            if (this.streamBlocked) {
                int limit = this.httpProperties.getInputBufferMinSize();
                if (limit < 0) {
                    limit = this.httpProperties.getInputBufferMaxSize();
                }
                if (this.currentLen - this.read < (long)limit) {
                    this.sendCallback();
                }
            }
            if (this.read >= this.currentLen) {
                if (this.connectionClosed) {
                    throw new HttpIOException("http_0025");
                }
                long startTime = System.currentTimeMillis();
                long delta = 0L;
                while (this.read >= this.currentLen && delta < (long)this.httpProperties.getServletInputStreamTimeout()) {
                    try {
                        ((Object)((Object)this)).wait(this.httpProperties.getServletInputStreamTimeout());
                    }
                    catch (IllegalMonitorStateException e) {
                        throw new HttpIOException("http_0065", e);
                    }
                    catch (InterruptedException e) {
                        throw new HttpIOException("http_0065", e);
                    }
                    delta = System.currentTimeMillis() - startTime;
                }
            }
            if (this.read >= this.currentLen) {
                if (this.totalLen == -1L) {
                    throw new HttpIOException("http_0026", new Object[]{"" + this.read, "End-Of-Chunk"});
                }
                throw new HttpIOException("http_0026", new Object[]{"" + this.read, "" + this.totalLen});
            }
            this.checkPointers();
            int avLen = this.contentLens[this.ptrToArr] + this.contentOffss[this.ptrToArr] - this.ptr;
            if (avLen > len) {
                System.arraycopy(this.content[this.ptrToArr], this.ptr, buf, off, len);
                this.read += (long)len;
                this.ptr += len;
                int n = len;
                return n;
            }
            System.arraycopy(this.content[this.ptrToArr], this.ptr, buf, off, avLen);
            this.read += (long)avLen;
            this.ptr += avLen;
            int n = avLen;
            return n;
        }
    }

    public int available() {
        HttpInputStream httpInputStream = this;
        synchronized (httpInputStream) {
            if (this.totalLen == -1L) {
                int n = (int)this.currentLen;
                return n;
            }
            if (this.hasMarkedUnread) {
                int n = (int)(this.totalLen - this.read + (long)this.markedBufferOffset);
                return n;
            }
            int n = (int)(this.totalLen - this.read);
            return n;
        }
    }

    public void mark(int count) {
        if (count > 4096) {
            throw new HttpIllegalArgumentException("http_0066", new Object[]{new Integer(count), new Integer(4096)});
        }
        this.marked = true;
        this.hasMarkedUnread = false;
        this.markedBuffer = new byte[count];
        this.markedBufferOffset = 0;
    }

    public void reset() {
        if (!this.marked) {
            return;
        }
        this.marked = false;
        if (this.markedBufferOffset > 0) {
            this.hasMarkedUnread = true;
            this.markedBufferReadOffset = 0;
        } else {
            this.hasMarkedUnread = false;
            this.markedBuffer = null;
        }
    }

    public boolean isEmpty() {
        return this.totalLen != -1L && this.available() == 0;
    }

    public boolean fill(byte[] nextData, int offset, int dataLen) {
        HttpInputStream httpInputStream = this;
        synchronized (httpInputStream) {
            if (this.contentPtr == this.content.length) {
                this.resize();
            }
            this.content[this.contentPtr] = nextData;
            this.contentLens[this.contentPtr] = dataLen;
            this.contentOffss[this.contentPtr] = offset;
            ++this.contentPtr;
            this.currentLen += (long)dataLen;
            ((Object)((Object)this)).notifyAll();
        }
        if (this.httpProperties.getInputBufferMaxSize() < 0 || this.currentLen - this.read < (long)this.httpProperties.getInputBufferMaxSize()) {
            return true;
        }
        this.streamBlocked = true;
        return false;
    }

    private void resize() {
        byte[][] temp = new byte[this.content.length + 100][];
        int[] tempLen = new int[this.contentLens.length + 100];
        int[] tempOffs = new int[this.contentOffss.length + 100];
        System.arraycopy(this.content, 0, temp, 0, this.content.length);
        System.arraycopy(this.contentLens, 0, tempLen, 0, this.contentLens.length);
        System.arraycopy(this.contentOffss, 0, tempOffs, 0, this.contentOffss.length);
        this.content = temp;
        this.contentLens = tempLen;
        this.contentOffss = tempOffs;
    }

    public void releaseBuffers() {
        while (this.ptrToArr < this.contentPtr) {
            if (this.ptrToArr != 0) {
                Processor.poolContext.release(this.content[this.ptrToArr]);
                this.content[this.ptrToArr] = null;
            }
            ++this.ptrToArr;
        }
    }

    public void connectionClosed() {
        HttpInputStream httpInputStream = this;
        synchronized (httpInputStream) {
            this.connectionClosed = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    private void checkPointers() {
        if (this.ptr == this.contentOffss[this.ptrToArr] + this.contentLens[this.ptrToArr]) {
            if (this.ptrToArr != 0) {
                Processor.poolContext.release(this.content[this.ptrToArr]);
                this.content[this.ptrToArr] = null;
            }
            ++this.ptrToArr;
            this.ptr = this.contentOffss[this.ptrToArr];
        }
    }

    private void sendCallback() {
        this.streamBlocked = false;
        this.client.sendStartReadCallback();
    }
}

