/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.io;

import com.sap.engine.services.httpserver.exceptions.HttpIOException;
import com.sap.engine.services.httpserver.exceptions.HttpIllegalArgumentException;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class ChunkedInputStream
extends ServletInputStream {
    private static final int BUFFER_SIZE = 4096;
    private InputStream input = null;
    private byte[] buffer = new byte[4096];
    private int bufferLength = -1;
    private int ptr = -1;
    private boolean empty = false;
    private int chunkLength = 0;
    private int readFromCurrentChunk = 0;

    public ChunkedInputStream(InputStream input) {
        this.input = input;
    }

    public int read() throws IOException {
        if (this.empty) {
            return -1;
        }
        if (this.ptr == -1 || this.ptr == this.bufferLength) {
            this.unchunkNext();
            if (this.empty) {
                return -1;
            }
        }
        return this.buffer[this.ptr++] & 0xFF;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int returnLen;
        if (off < 0 || len <= 0 || buf == null || buf.length < off + len) {
            throw new HttpIllegalArgumentException("http_0027");
        }
        if (this.empty) {
            return -1;
        }
        if (this.ptr == -1 || this.ptr == this.bufferLength) {
            this.unchunkNext();
            if (this.empty) {
                return -1;
            }
        }
        if ((returnLen = len) > this.bufferLength - this.ptr) {
            returnLen = this.bufferLength - this.ptr;
        }
        System.arraycopy(this.buffer, this.ptr, buf, off, returnLen);
        this.ptr += returnLen;
        return returnLen;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void unchunkNext() throws IOException {
        if (this.ptr != -1) {
            this.readFromCurrentChunk += this.ptr;
        }
        if (this.readFromCurrentChunk == this.chunkLength) {
            this.chunkLength = this.readLength();
            this.readFromCurrentChunk = 0;
            if (this.chunkLength == 0) {
                this.empty = true;
                return;
            }
        }
        this.ptr = 0;
        this.bufferLength = this.chunkLength - this.readFromCurrentChunk > 4096 ? 4096 : this.chunkLength - this.readFromCurrentChunk;
        int ptr = 0;
        int read = -1;
        while (ptr < this.bufferLength && (read = this.input.read(this.buffer, ptr, this.bufferLength - ptr)) != -1) {
            ptr += read;
        }
        if (this.bufferLength == this.chunkLength - this.readFromCurrentChunk) {
            this.input.read();
            this.input.read();
        }
    }

    private int readLength() throws IOException {
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        int c = -1;
        boolean RFound = false;
        while ((c = this.input.read()) != -1) {
            line.write(c & 0xFF);
            if (RFound && c == 10) {
                byte[] res = line.toByteArray();
                return Ascii.asciiArrHexToInt(res, 0, res.length - 2);
            }
            RFound = false;
            if (c != 13) continue;
            RFound = true;
        }
        throw new HttpIOException("http_0019");
    }
}

