/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.io;

public class ByteArrayOutputStream {
    private static final int BUFFER_SIZE = 4096;
    private byte[] buffer = new byte[4096];
    private int ptr = 0;
    private byte[] all = new byte[0];

    public void write(byte b) {
        this.buffer[this.ptr++] = b;
        if (this.ptr == 4096) {
            this.flush();
        }
    }

    public void write(int b) {
        this.write((byte)b);
    }

    public void write(byte[] b) {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        if (b == null || off < 0 || len < 0 || off + len > b.length) {
            return;
        }
        if (len > 4096 - this.ptr) {
            System.arraycopy(b, off, this.buffer, this.ptr, 4096 - this.ptr);
            this.ptr += (len -= 4096 - this.ptr);
            this.flush();
            this.write(b, off += 4096 - this.ptr, len);
        } else {
            System.arraycopy(b, off, this.buffer, this.ptr, len);
            this.ptr += len;
            if (this.ptr == 4096) {
                this.flush();
            }
        }
    }

    public void flush() {
        if (this.ptr > 0) {
            byte[] tmp = new byte[this.all.length + this.ptr];
            System.arraycopy(this.all, 0, tmp, 0, this.all.length);
            System.arraycopy(this.buffer, 0, tmp, this.all.length, this.ptr);
            this.all = tmp;
        }
        this.ptr = 0;
    }

    public void reset() {
        this.ptr = 0;
        this.all = new byte[0];
    }

    public int size() {
        return this.all.length + this.ptr;
    }

    public byte[] toByteArray() {
        if (this.ptr > 0) {
            byte[] tmp = new byte[this.all.length + this.ptr];
            System.arraycopy(this.all, 0, tmp, 0, this.all.length);
            System.arraycopy(this.buffer, 0, tmp, this.all.length, this.ptr);
            this.all = tmp;
        }
        return this.all;
    }
}

