/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.hosts.impl;

import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.services.httpserver.exceptions.IllegalHostArgumentsException;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.hosts.Host;
import com.sap.engine.services.httpserver.server.hosts.impl.ConfigurationReader;

public class HttpHostListener
implements ConfigurationChangedListener {
    private ConfigurationReader configurationReader = null;
    private HttpHosts httpHosts = null;
    private ConfigurationHandlerFactory factory = null;
    private boolean isGlobal = false;

    public HttpHostListener(ConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public HttpHostListener(HttpHosts httpHosts, ConfigurationHandlerFactory factory) {
        this.httpHosts = httpHosts;
        this.factory = factory;
        this.isGlobal = true;
    }

    public void configurationChanged(ChangeEvent e) {
        if (e.getAction() != 0) {
            return;
        }
        try {
            if (this.isGlobal) {
                this.checkChange();
            } else {
                this.configurationReader.readConfiguration(true);
            }
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            Log.logWarning("Cannot synchronize local host properties with configuration. Error in processing ACTION_MODIFIED event", t, null);
            return;
        }
    }

    private void checkChange() throws ConfigurationException, IllegalHostArgumentsException {
        Host[] local = this.httpHosts.getAllHosts();
        String[] localHosts = new String[local.length];
        int i = 0;
        while (i < local.length) {
            localHosts[i] = local[i].getHostName();
            ++i;
        }
        String[] dbHosts = null;
        ConfigurationHandler handler = null;
        try {
            handler = this.factory.getConfigurationHandler();
            Configuration hostsConfig = handler.openConfiguration("HttpHosts", 0);
            dbHosts = hostsConfig.getAllSubConfigurationNames();
            handler.commit();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            handler.closeAllConfigurations();
            throw throwable;
        }
        handler.closeAllConfigurations();
        int i2 = 0;
        while (i2 < localHosts.length) {
            if (!this.findIn(dbHosts, localHosts[i2])) {
                this.httpHosts.removeHost(localHosts[i2], true);
                return;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < dbHosts.length) {
            if (!this.findIn(localHosts, dbHosts[i3])) {
                this.httpHosts.createAndStoreHost(dbHosts[i3]);
                return;
            }
            ++i3;
        }
    }

    private boolean findIn(String[] all, String host) {
        int i = 0;
        while (i < all.length) {
            if (all[i].equals(host)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

