/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.hosts.impl;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.httpserver.HostPropertiesRuntimeInterface;
import com.sap.engine.services.httpserver.exceptions.IllegalHostArgumentsException;
import com.sap.engine.services.httpserver.server.hosts.HostProperties;
import com.sap.engine.services.httpserver.server.hosts.HostPropertiesModifier;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class HostPropertiesRuntimeInterfaceImpl
extends PortableRemoteObject
implements HostPropertiesRuntimeInterface {
    private HttpProperties httpProperties = null;
    private HostProperties hostProperties = null;
    private HostPropertiesModifier hostPropertiesModifier = null;

    public HostPropertiesRuntimeInterfaceImpl(HttpProperties httpProperties, HostProperties hostProperties, HostPropertiesModifier hostPropertiesModifier) throws RemoteException {
        this.httpProperties = httpProperties;
        this.hostProperties = hostProperties;
        this.hostPropertiesModifier = hostPropertiesModifier;
    }

    public String getHostName() throws RemoteException {
        return this.hostProperties.getHostName();
    }

    public boolean isKeepAliveEnabled() throws RemoteException {
        return this.hostProperties.isKeepAliveEnabled();
    }

    public boolean isList() throws RemoteException {
        return this.hostProperties.isList();
    }

    public boolean isLogEnabled() throws RemoteException {
        return this.hostProperties.isLogEnabled();
    }

    public boolean isUseCache() throws RemoteException {
        return this.hostProperties.isUseCache();
    }

    public String getStartPage() throws RemoteException {
        return this.hostProperties.getStartPage();
    }

    public String getRootDir() throws RemoteException {
        return this.hostProperties.getRootDir();
    }

    public String[] getAliasNames() throws RemoteException {
        return this.hostProperties.getAliasNames();
    }

    public String getAliasValue(String key) throws RemoteException {
        String res = this.hostProperties.getAliasValue(key);
        if (res != null) {
            return res;
        }
        int zoneInd = -1;
        if (this.httpProperties.getZoneSeparator() != null) {
            zoneInd = key.indexOf(this.httpProperties.getZoneSeparator());
        }
        if (zoneInd == -1) {
            return null;
        }
        return this.hostProperties.getAliasValue(key.substring(0, zoneInd));
    }

    public boolean isApplicationAlias(String key) throws RemoteException {
        return this.hostProperties.isApplicationAlias(key);
    }

    public boolean isApplicationAliasEnabled(String key) throws RemoteException {
        return this.hostProperties.isApplicationAliasEnabled(key);
    }

    public void setKeepAliveEnabled(boolean keepAliveEnabled) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.setKeepAliveEnabled(keepAliveEnabled);
    }

    public void setList(boolean list) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.setList(list);
    }

    public void setLogEnabled(boolean enableLog) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.setLogEnabled(enableLog);
    }

    public void setUseCache(boolean useCache) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.setUseCache(useCache);
    }

    public void setStartPage(String startPage) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.setStartPage(startPage);
    }

    public void setRootDir(String vDir) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.setRootDir(vDir);
    }

    public void addHttpAlias(String alias, String value) throws ConfigurationException, IllegalHostArgumentsException, RemoteException {
        this.hostPropertiesModifier.addHttpAlias(alias, value);
    }

    public void removeHttpAlias(String alias) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.removeHttpAlias(alias);
    }

    public void changeHttpAlias(String alias, String value) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.changeHttpAlias(alias, value);
    }

    public void enableApplicationAlias(String alias) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.enableApplicationAlias(alias);
    }

    public void disableApplicationAlias(String alias) throws ConfigurationException, RemoteException {
        this.hostPropertiesModifier.disableApplicationAlias(alias);
    }
}

